/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.util.AbstractQueue;
import java.util.List;

public class Node {
    private Object state;
    private Node parent;
    private String action;
    Double pathCost;
    private int depth;
    private Double stepCost;

    public Node(Object object) {
        this.state = object;
        this.depth = 0;
        this.stepCost = new Double(0.0);
        this.pathCost = new Double(0.0);
    }

    public Node(Node node, Object object) {
        this(object);
        this.parent = node;
        this.depth = node.getDepth() + 1;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getPathFromRoot() {
        Node node = this;
        AbstractQueue abstractQueue = new AbstractQueue();
        while (!node.isRootNode()) {
            abstractQueue.addToFront(node);
            node = node.getParent();
        }
        abstractQueue.addToFront(node);
        return abstractQueue.asList();
    }

    public Object getState() {
        return this.state;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getAction() {
        return this.action;
    }

    public void setStepCost(Double d) {
        this.stepCost = d;
    }

    public void addToPathCost(Double d) {
        this.pathCost = new Double(this.parent.pathCost + d);
    }

    public double getPathCost() {
        return this.pathCost;
    }

    public double getStepCost() {
        return this.stepCost;
    }

    public String toString() {
        return this.getState().toString();
    }
}

