/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.Randomizer;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.Particle;
import aima.probability.reasoning.ParticleSet;
import aima.util.Matrix;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class RandomVariable {
    private String name;
    private Hashtable<String, Double> distribution;
    private List<String> states;

    public RandomVariable(List<String> list) {
        this("HiddenState", list);
    }

    public RandomVariable(String string, List<String> list) {
        this.name = string;
        this.states = list;
        this.distribution = new Hashtable();
        int n = list.size();
        double d = 1.0 / (double)n;
        for (String string2 : list) {
            this.distribution.put(string2, d);
        }
    }

    private RandomVariable(String string, List<String> list, Hashtable<String, Double> hashtable) {
        this.name = string;
        this.states = list;
        this.distribution = hashtable;
    }

    public void setProbabilityOf(String string, Double d) {
        if (!this.states.contains(string)) {
            throw new RuntimeException(string + "  is an invalid state");
        }
        this.distribution.put(string, d);
    }

    public double getProbabilityOf(String string) {
        if (this.states.contains(string)) {
            return this.distribution.get(string);
        }
        throw new RuntimeException(string + "  is an invalid state");
    }

    public List<String> states() {
        return this.states;
    }

    public RandomVariable duplicate() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        for (String string : this.distribution.keySet()) {
            hashtable.put(string, this.distribution.get(string));
        }
        return new RandomVariable(this.name, this.states, hashtable);
    }

    public void normalize() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (String string : this.states) {
            arrayList.add(this.distribution.get(string));
        }
        List<Double> list = Util.normalize(arrayList);
        for (int i = 0; i < this.states.size(); ++i) {
            this.distribution.put(this.states.get(i), (Double)list.get(i));
        }
    }

    public Matrix asMatrix() {
        Matrix matrix = new Matrix(this.states.size(), 1);
        for (int i = 0; i < this.states.size(); ++i) {
            matrix.set(i, 0, this.distribution.get(this.states.get(i)));
        }
        return matrix;
    }

    public void updateFrom(Matrix matrix) {
        for (int i = 0; i < this.states.size(); ++i) {
            this.distribution.put(this.states.get(i), matrix.get(i, 0));
        }
    }

    public RandomVariable createUnitBelief() {
        RandomVariable randomVariable = this.duplicate();
        for (String string : this.states()) {
            randomVariable.setProbabilityOf(string, 1.0);
        }
        return randomVariable;
    }

    public String toString() {
        return this.asMatrix().toString();
    }

    public ParticleSet toParticleSet(HiddenMarkovModel hiddenMarkovModel, Randomizer randomizer, int n) {
        ParticleSet particleSet = new ParticleSet(hiddenMarkovModel);
        for (int i = 0; i < n; ++i) {
            double d = randomizer.nextDouble();
            String string = this.getStateForRandomNumber(d);
            particleSet.add(new Particle(string, 0.0));
        }
        return particleSet;
    }

    private String getStateForRandomNumber(double d) {
        double d2 = 0.0;
        for (String string : this.states) {
            if (!((d2 += this.distribution.get(string).doubleValue()) >= d)) continue;
            return string;
        }
        throw new RuntimeException("cannot handle " + d);
    }
}

