/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.BayesNetNode;
import aima.probability.JavaRandomizer;
import aima.probability.Randomizer;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class BayesNet {
    private List<BayesNetNode> roots = new ArrayList<BayesNetNode>();
    private List<BayesNetNode> variableNodes;

    public BayesNet(BayesNetNode bayesNetNode) {
        this.roots.add(bayesNetNode);
    }

    public BayesNet(BayesNetNode bayesNetNode, BayesNetNode bayesNetNode2) {
        this(bayesNetNode);
        this.roots.add(bayesNetNode2);
    }

    public BayesNet(BayesNetNode bayesNetNode, BayesNetNode bayesNetNode2, BayesNetNode bayesNetNode3) {
        this(bayesNetNode, bayesNetNode2);
        this.roots.add(bayesNetNode3);
    }

    public BayesNet(List<BayesNetNode> list) {
        this.roots = list;
    }

    public List<String> getVariables() {
        this.variableNodes = this.getVariableNodes();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BayesNetNode bayesNetNode : this.variableNodes) {
            arrayList.add(bayesNetNode.getVariable());
        }
        return arrayList;
    }

    private List<BayesNetNode> getVariableNodes() {
        if (this.variableNodes == null) {
            ArrayList<BayesNetNode> arrayList = new ArrayList<BayesNetNode>();
            List<BayesNetNode> list = this.roots;
            ArrayList<BayesNetNode> arrayList2 = new ArrayList<BayesNetNode>();
            while (list.size() != 0) {
                ArrayList<BayesNetNode> arrayList3 = new ArrayList<BayesNetNode>();
                for (BayesNetNode bayesNetNode : list) {
                    if (arrayList2.contains(bayesNetNode)) continue;
                    arrayList.add(bayesNetNode);
                    List<BayesNetNode> list2 = bayesNetNode.getChildren();
                    for (BayesNetNode bayesNetNode2 : list2) {
                        if (arrayList3.contains(bayesNetNode2)) continue;
                        arrayList3.add(bayesNetNode2);
                    }
                    arrayList2.add(bayesNetNode);
                }
                list = arrayList3;
            }
            this.variableNodes = arrayList;
        }
        return this.variableNodes;
    }

    private BayesNetNode getNodeOf(String string) {
        List<BayesNetNode> list = this.getVariableNodes();
        for (BayesNetNode bayesNetNode : list) {
            if (!bayesNetNode.getVariable().equals(string)) continue;
            return bayesNetNode;
        }
        return null;
    }

    public double probabilityOf(String string, Boolean bl, Hashtable<String, Boolean> hashtable) {
        BayesNetNode bayesNetNode = this.getNodeOf(string);
        if (bayesNetNode == null) {
            throw new RuntimeException("Unable to find a node with variable " + string);
        }
        List<BayesNetNode> list = bayesNetNode.getParents();
        if (list.size() == 0) {
            Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
            hashtable2.put(string, bl);
            double d = bayesNetNode.probabilityOf(hashtable2);
            return d;
        }
        Hashtable<String, Boolean> hashtable3 = new Hashtable<String, Boolean>();
        for (BayesNetNode bayesNetNode2 : list) {
            hashtable3.put(bayesNetNode2.getVariable(), hashtable.get(bayesNetNode2.getVariable()));
        }
        double d = bayesNetNode.probabilityOf(hashtable3);
        if (bl.equals(Boolean.TRUE)) {
            return d;
        }
        return 1.0 - d;
    }

    public Hashtable getPriorSample(Randomizer randomizer) {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        List<BayesNetNode> list = this.getVariableNodes();
        for (BayesNetNode bayesNetNode : list) {
            hashtable.put(bayesNetNode.getVariable(), bayesNetNode.isTrueFor(randomizer.nextDouble(), hashtable));
        }
        return hashtable;
    }

    public Hashtable getPriorSample() {
        return this.getPriorSample(new JavaRandomizer());
    }

    public double[] rejectionSample(String string, Hashtable hashtable, int n, Randomizer randomizer) {
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            Hashtable hashtable2 = this.getPriorSample(randomizer);
            if (!this.consistent(hashtable2, hashtable)) continue;
            boolean bl = (Boolean)hashtable2.get(string);
            if (bl) {
                dArray[0] = dArray[0] + 1.0;
                continue;
            }
            dArray[1] = dArray[1] + 1.0;
        }
        return Util.normalize(dArray);
    }

    private boolean consistent(Hashtable hashtable, Hashtable hashtable2) {
        for (String string : hashtable2.keySet()) {
            Boolean bl = (Boolean)hashtable2.get(string);
            if (bl.equals(hashtable.get(string))) continue;
            return false;
        }
        return true;
    }

    public double[] likelihoodWeighting(String string, Hashtable<String, Boolean> hashtable, int n, Randomizer randomizer) {
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
            double d = 1.0;
            List<BayesNetNode> list = this.getVariableNodes();
            for (BayesNetNode bayesNetNode : list) {
                if (hashtable.get(bayesNetNode.getVariable()) != null) {
                    d *= bayesNetNode.probabilityOf(hashtable2);
                    hashtable2.put(bayesNetNode.getVariable(), hashtable.get(bayesNetNode.getVariable()));
                    continue;
                }
                hashtable2.put(bayesNetNode.getVariable(), bayesNetNode.isTrueFor(randomizer.nextDouble(), hashtable2));
            }
            boolean bl = (Boolean)hashtable2.get(string);
            if (bl) {
                dArray[0] = dArray[0] + d;
                continue;
            }
            dArray[1] = dArray[1] + d;
        }
        return Util.normalize(dArray);
    }

    public double[] mcmcAsk(String string, Hashtable<String, Boolean> hashtable, int n, Randomizer randomizer) {
        double[] dArray = new double[2];
        List list = this.nonEvidenceVariables(hashtable, string);
        Hashtable<String, Boolean> hashtable2 = this.createRandomEvent(list, hashtable, randomizer);
        for (int i = 0; i < n; ++i) {
            for (String string2 : list) {
                BayesNetNode bayesNetNode = this.getNodeOf(string2);
                List<BayesNetNode> list2 = this.markovBlanket(bayesNetNode);
                Hashtable hashtable3 = this.createMBValues(list2, hashtable2);
                hashtable2.put(bayesNetNode.getVariable(), this.truthValue(this.rejectionSample(bayesNetNode.getVariable(), hashtable3, 100, randomizer), randomizer));
                boolean bl = hashtable2.get(string);
                if (bl) {
                    dArray[0] = dArray[0] + 1.0;
                    continue;
                }
                dArray[1] = dArray[1] + 1.0;
            }
        }
        return Util.normalize(dArray);
    }

    private Boolean truthValue(double[] dArray, Randomizer randomizer) {
        double d = randomizer.nextDouble();
        if (d < dArray[0]) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Hashtable<String, Boolean> createRandomEvent(List list, Hashtable<String, Boolean> hashtable, Randomizer randomizer) {
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        List<String> list2 = this.getVariables();
        for (String string : list2) {
            if (list.contains(string)) {
                Boolean bl = randomizer.nextDouble() <= 0.5 ? Boolean.TRUE : Boolean.FALSE;
                hashtable2.put(string, bl);
                continue;
            }
            hashtable2.put(string, hashtable.get(string));
        }
        return hashtable2;
    }

    private List nonEvidenceVariables(Hashtable<String, Boolean> hashtable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.getVariables();
        for (String string2 : list) {
            if (hashtable.keySet().contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List<BayesNetNode> markovBlanket(BayesNetNode bayesNetNode) {
        return this.markovBlanket(bayesNetNode, new ArrayList<BayesNetNode>());
    }

    private List<BayesNetNode> markovBlanket(BayesNetNode bayesNetNode, List<BayesNetNode> list) {
        List<BayesNetNode> list2 = bayesNetNode.getParents();
        for (BayesNetNode object2 : list2) {
            if (list.contains(object2)) continue;
            list.add(object2);
        }
        List<BayesNetNode> list3 = bayesNetNode.getChildren();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            BayesNetNode bayesNetNode2 = (BayesNetNode)iterator.next();
            if (list.contains(bayesNetNode2)) continue;
            list.add(bayesNetNode2);
            List<BayesNetNode> list4 = bayesNetNode2.getParents();
            for (BayesNetNode bayesNetNode3 : list4) {
                if (list.contains(bayesNetNode3) || bayesNetNode3.equals(bayesNetNode)) continue;
                list.add(bayesNetNode3);
            }
        }
        return list;
    }

    private Hashtable createMBValues(List<BayesNetNode> list, Hashtable<String, Boolean> hashtable) {
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        for (BayesNetNode bayesNetNode : list) {
            hashtable2.put(bayesNetNode.getVariable(), hashtable.get(bayesNetNode.getVariable()));
        }
        return hashtable2;
    }

    public double[] mcmcAsk(String string, Hashtable<String, Boolean> hashtable, int n) {
        return this.mcmcAsk(string, hashtable, n, new JavaRandomizer());
    }

    public double[] likelihoodWeighting(String string, Hashtable<String, Boolean> hashtable, int n) {
        return this.likelihoodWeighting(string, hashtable, n, new JavaRandomizer());
    }

    public double[] rejectionSample(String string, Hashtable<String, Boolean> hashtable, int n) {
        return this.rejectionSample(string, hashtable, n, new JavaRandomizer());
    }
}

