/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb.data;

import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.inference.proof.ProofStepChainContrapositive;
import aima.logic.fol.inference.proof.ProofStepPremise;
import aima.logic.fol.kb.data.Literal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Chain {
    private static List<Literal> _emptyLiteralsList = Collections.unmodifiableList(new ArrayList());
    private List<Literal> literals = new ArrayList<Literal>();
    private ProofStep proofStep = null;

    public Chain() {
    }

    public Chain(List<Literal> list) {
        this.literals.addAll(list);
    }

    public Chain(Set<Literal> set) {
        this.literals.addAll(set);
    }

    public ProofStep getProofStep() {
        if (null == this.proofStep) {
            this.proofStep = new ProofStepPremise(this);
        }
        return this.proofStep;
    }

    public void setProofStep(ProofStep proofStep) {
        this.proofStep = proofStep;
    }

    public boolean isEmpty() {
        return this.literals.size() == 0;
    }

    public void addLiteral(Literal literal) {
        this.literals.add(literal);
    }

    public Literal getHead() {
        if (0 == this.literals.size()) {
            return null;
        }
        return this.literals.get(0);
    }

    public List<Literal> getTail() {
        if (0 == this.literals.size()) {
            return _emptyLiteralsList;
        }
        return Collections.unmodifiableList(this.literals.subList(1, this.literals.size()));
    }

    public int getNumberLiterals() {
        return this.literals.size();
    }

    public List<Literal> getLiterals() {
        return Collections.unmodifiableList(this.literals);
    }

    public List<Chain> getContrapositives() {
        ArrayList<Chain> arrayList = new ArrayList<Chain>();
        ArrayList<Literal> arrayList2 = new ArrayList<Literal>();
        for (int i = 1; i < this.literals.size(); ++i) {
            arrayList2.clear();
            arrayList2.add(this.literals.get(i));
            arrayList2.addAll(this.literals.subList(0, i));
            arrayList2.addAll(this.literals.subList(i + 1, this.literals.size()));
            Chain chain = new Chain(arrayList2);
            chain.setProofStep(new ProofStepChainContrapositive(chain, this));
            arrayList.add(chain);
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        for (int i = 0; i < this.literals.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.literals.get(i).toString());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

