/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStepGoal;
import aima.logic.fol.inference.trace.FOLTFMResolutionTracer;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FOLTFMResolution
implements InferenceProcedure {
    private long maxQueryTime = 10000L;
    private FOLTFMResolutionTracer tracer = null;

    public FOLTFMResolution() {
    }

    public FOLTFMResolution(long l) {
        this.setMaxQueryTime(l);
    }

    public FOLTFMResolution(FOLTFMResolutionTracer fOLTFMResolutionTracer) {
        this.setTracer(fOLTFMResolutionTracer);
    }

    public long getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(long l) {
        this.maxQueryTime = l;
    }

    public FOLTFMResolutionTracer getTracer() {
        return this.tracer;
    }

    public void setTracer(FOLTFMResolutionTracer fOLTFMResolutionTracer) {
        this.tracer = fOLTFMResolutionTracer;
    }

    @Override
    public InferenceResult ask(FOLKnowledgeBase fOLKnowledgeBase, Sentence sentence) {
        Object object;
        LinkedHashSet<Clause> linkedHashSet2 = new LinkedHashSet<Clause>();
        for (Clause clause : fOLKnowledgeBase.getAllClauses()) {
            Clause object32 = fOLKnowledgeBase.standardizeApart(clause);
            object32.setStandardizedApartCheckNotRequired();
            linkedHashSet2.addAll(object32.getFactors());
        }
        NotSentence notSentence = new NotSentence(sentence);
        Literal literal = fOLKnowledgeBase.createAnswerLiteral(notSentence);
        Set<Variable> set = fOLKnowledgeBase.collectAllVariables(literal.getAtomicSentence());
        Clause clause = new Clause();
        if (set.size() > 0) {
            object = new ConnectedSentence("OR", notSentence, literal.getAtomicSentence());
            for (Clause clause2 : fOLKnowledgeBase.convertToClauses((Sentence)object)) {
                Clause clause3 = fOLKnowledgeBase.standardizeApart(clause2);
                clause3.setProofStep(new ProofStepGoal(clause3));
                clause3.setStandardizedApartCheckNotRequired();
                linkedHashSet2.addAll(clause3.getFactors());
            }
            clause.addLiteral(literal);
        } else {
            for (Clause clause4 : fOLKnowledgeBase.convertToClauses(notSentence)) {
                Clause clause5 = fOLKnowledgeBase.standardizeApart(clause4);
                clause5.setProofStep(new ProofStepGoal(clause5));
                clause5.setStandardizedApartCheckNotRequired();
                linkedHashSet2.addAll(clause5.getFactors());
            }
        }
        object = new TFMAnswerHandler(literal, set, clause, this.maxQueryTime);
        LinkedHashSet<Clause> linkedHashSet = new LinkedHashSet<Clause>();
        LinkedHashSet<Clause> linkedHashSet3 = new LinkedHashSet<Clause>();
        int n = linkedHashSet2.size();
        do {
            if (null != this.tracer) {
                this.tracer.stepStartWhile(linkedHashSet2, linkedHashSet2.size(), linkedHashSet.size());
            }
            linkedHashSet.clear();
            Clause[] clauseArray = new Clause[linkedHashSet2.size()];
            linkedHashSet2.toArray(clauseArray);
            for (int i = 0; i < clauseArray.length; ++i) {
                Clause clause6 = clauseArray[i];
                if (null != this.tracer) {
                    this.tracer.stepOuterFor(clause6);
                }
                for (int j = i; j < clauseArray.length; ++j) {
                    Set<Clause> set2;
                    Clause clause7 = clauseArray[j];
                    if (null != this.tracer) {
                        this.tracer.stepInnerFor(clause6, clause7);
                    }
                    if ((set2 = clause6.binaryResolvents(clause7)).size() > 0) {
                        linkedHashSet3.clear();
                        for (Clause clause8 : set2) {
                            linkedHashSet3.addAll(clause8.getFactors());
                        }
                        if (null != this.tracer) {
                            this.tracer.stepResolved(clause6, clause7, linkedHashSet3);
                        }
                        ((TFMAnswerHandler)object).checkForPossibleAnswers(linkedHashSet3);
                        if (((TFMAnswerHandler)object).isComplete()) break;
                        linkedHashSet.addAll(linkedHashSet3);
                    }
                    if (((TFMAnswerHandler)object).isComplete()) break;
                }
                if (((TFMAnswerHandler)object).isComplete()) break;
            }
            n = linkedHashSet2.size();
            linkedHashSet2.addAll(linkedHashSet);
        } while (!((TFMAnswerHandler)object).isComplete() && n < linkedHashSet2.size());
        if (null != this.tracer) {
            this.tracer.stepFinished(linkedHashSet2, (InferenceResult)object);
        }
        return object;
    }

    class TFMAnswerHandler
    implements InferenceResult {
        private Literal answerLiteral = null;
        private Set<Variable> answerLiteralVariables = null;
        private Clause answerClause = null;
        private long finishTime = 0L;
        private boolean complete = false;
        private List<Proof> proofs = new ArrayList<Proof>();
        private boolean timedOut = false;

        public TFMAnswerHandler(Literal literal, Set<Variable> set, Clause clause, long l) {
            this.answerLiteral = literal;
            this.answerLiteralVariables = set;
            this.answerClause = clause;
            this.finishTime = System.currentTimeMillis() + l;
        }

        @Override
        public boolean isPossiblyFalse() {
            return !this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return this.timedOut && this.proofs.size() > 0;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public boolean isComplete() {
            return this.complete;
        }

        private void checkForPossibleAnswers(Set<Clause> set) {
            for (Clause clause : set) {
                if (this.answerClause.isEmpty()) {
                    if (clause.isEmpty()) {
                        this.proofs.add(new ProofFinal(clause.getProofStep(), new HashMap<Variable, Term>()));
                        this.complete = true;
                    }
                } else {
                    if (clause.isEmpty()) {
                        throw new IllegalStateException("Generated an empty clause while looking for an answer, implies original KB is unsatisfiable");
                    }
                    if (clause.isUnitClause() && clause.isDefiniteClause() && clause.getPositiveLiterals().get(0).getAtomicSentence().getSymbolicName().equals(this.answerLiteral.getAtomicSentence().getSymbolicName())) {
                        HashMap<Variable, Term> hashMap = new HashMap<Variable, Term>();
                        List<Term> list = clause.getPositiveLiterals().get(0).getAtomicSentence().getArgs();
                        int n = 0;
                        for (Variable variable : this.answerLiteralVariables) {
                            hashMap.put(variable, list.get(n));
                            ++n;
                        }
                        boolean bl = true;
                        for (Proof proof : this.proofs) {
                            if (!((Object)proof.getAnswerBindings()).equals(hashMap)) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            this.proofs.add(new ProofFinal(clause.getProofStep(), hashMap));
                        }
                    }
                }
                if (System.currentTimeMillis() <= this.finishTime) continue;
                this.complete = true;
                this.timedOut = true;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("isComplete=" + this.complete);
            stringBuilder.append("\n");
            stringBuilder.append("result=" + this.proofs);
            return stringBuilder.toString();
        }
    }
}

