/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.reinforcement;

import aima.learning.reinforcement.MDPAgent;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPPerception;
import aima.probability.decision.MDPPolicy;
import aima.probability.decision.MDPTransition;
import aima.probability.decision.MDPUtilityFunction;
import aima.util.Pair;
import java.util.Hashtable;
import java.util.List;

public class PassiveADPAgent<STATE_TYPE, ACTION_TYPE>
extends MDPAgent<STATE_TYPE, ACTION_TYPE> {
    private MDPPolicy<STATE_TYPE, ACTION_TYPE> policy;
    private MDPUtilityFunction<STATE_TYPE> utilityFunction;
    private Hashtable<Pair<STATE_TYPE, ACTION_TYPE>, Double> nsa;
    private Hashtable<MDPTransition<STATE_TYPE, ACTION_TYPE>, Double> nsasdash;

    public PassiveADPAgent(MDP<STATE_TYPE, ACTION_TYPE> mDP, MDPPolicy<STATE_TYPE, ACTION_TYPE> mDPPolicy) {
        super(mDP.emptyMdp());
        this.policy = mDPPolicy;
        this.utilityFunction = new MDPUtilityFunction();
        this.nsa = new Hashtable();
        this.nsasdash = new Hashtable();
    }

    @Override
    public ACTION_TYPE decideAction(MDPPerception<STATE_TYPE> mDPPerception) {
        if (!this.utilityFunction.hasUtilityFor(mDPPerception.getState())) {
            this.utilityFunction.setUtility(mDPPerception.getState(), mDPPerception.getReward());
            this.mdp.setReward(mDPPerception.getState(), mDPPerception.getReward());
        }
        if (this.previousState != null) {
            Double d = this.nsa.get(new Pair<Object, Object>(this.previousState, this.previousAction));
            if (d == null) {
                this.nsa.put(new Pair<Object, Object>(this.previousState, this.previousAction), 1.0);
            } else {
                this.nsa.put(new Pair<Object, Object>(this.previousState, this.previousAction), d + 1.0);
            }
            Double d2 = this.nsasdash.get(new MDPTransition<Object, Object>(this.previousState, this.previousAction, this.currentState));
            if (d2 == null) {
                this.nsasdash.put(new MDPTransition<Object, Object>(this.previousState, this.previousAction, this.currentState), 1.0);
            } else {
                this.nsasdash.put(new MDPTransition<Object, Object>(this.previousState, this.previousAction, this.currentState), d2 + 1.0);
            }
            for (MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition : this.nsasdash.keySet()) {
                if (this.nsasdash.get(mDPTransition) == 0.0) continue;
                double d3 = this.nsasdash.get(mDPTransition) / this.nsa.get(new Pair<STATE_TYPE, ACTION_TYPE>(mDPTransition.getInitialState(), mDPTransition.getAction()));
                this.mdp.setTransitionProbability(mDPTransition, d3);
            }
            List<MDPTransition<Object, ACTION_TYPE>> list = this.mdp.getTransitionsWith(this.previousState, this.policy.getAction(this.previousState));
            this.utilityFunction = this.valueDetermination(list, 1.0);
        }
        if (this.mdp.isTerminalState(this.currentState)) {
            this.previousState = null;
            this.previousAction = null;
        } else {
            this.previousState = this.currentState;
            this.previousAction = this.policy.getAction(this.currentState);
        }
        return (ACTION_TYPE)this.previousAction;
    }

    private MDPUtilityFunction<STATE_TYPE> valueDetermination(List<MDPTransition<STATE_TYPE, ACTION_TYPE>> list, double d) {
        MDPUtilityFunction<STATE_TYPE> mDPUtilityFunction = this.utilityFunction.copy();
        double d2 = 0.0;
        if (list.size() > 0) {
            STATE_TYPE STATE_TYPE = list.get(0).getInitialState();
            double d3 = this.mdp.getRewardFor(STATE_TYPE);
            for (MDPTransition<STATE_TYPE, ACTION_TYPE> mDPTransition : list) {
                d2 += this.mdp.getTransitionProbability(mDPTransition) * this.utilityFunction.getUtility(mDPTransition.getDestinationState());
            }
            mDPUtilityFunction.setUtility(STATE_TYPE, d3 + d * d2);
        }
        return mDPUtilityFunction;
    }

    public MDPUtilityFunction<STATE_TYPE> getUtilityFunction() {
        return this.utilityFunction;
    }
}

