/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.reinforcement;

import aima.probability.Randomizer;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPPerception;

public abstract class MDPAgent<STATE_TYPE, ACTION_TYPE> {
    protected MDP<STATE_TYPE, ACTION_TYPE> mdp;
    protected STATE_TYPE currentState;
    protected Double currentReward;
    protected STATE_TYPE previousState;
    protected ACTION_TYPE previousAction;

    public MDPAgent(MDP<STATE_TYPE, ACTION_TYPE> mDP) {
        this.mdp = mDP;
        this.currentState = mDP.getInitialState();
        this.currentReward = mDP.getRewardFor(this.currentState);
    }

    public MDPPerception<STATE_TYPE> execute(ACTION_TYPE ACTION_TYPE, Randomizer randomizer) {
        MDPPerception<STATE_TYPE> mDPPerception = this.mdp.execute(this.currentState, ACTION_TYPE, randomizer);
        this.updateFromPerception(mDPPerception);
        return mDPPerception;
    }

    public void updateFromPerception(MDPPerception<STATE_TYPE> mDPPerception) {
        this.currentState = mDPPerception.getState();
        this.currentReward = mDPPerception.getReward();
    }

    public void executeTrial(Randomizer randomizer) {
        this.currentState = this.mdp.getInitialState();
        this.currentReward = this.mdp.getRewardFor(this.mdp.getInitialState());
        this.previousState = null;
        this.previousAction = null;
        MDPPerception<STATE_TYPE> mDPPerception = new MDPPerception<STATE_TYPE>(this.currentState, this.currentReward);
        ACTION_TYPE ACTION_TYPE = null;
        do {
            if ((ACTION_TYPE = (ACTION_TYPE)this.decideAction(mDPPerception)) == null) continue;
            mDPPerception = this.execute(ACTION_TYPE, randomizer);
        } while (ACTION_TYPE != null);
    }

    public abstract ACTION_TYPE decideAction(MDPPerception<STATE_TYPE> var1);

    public Double getCurrentReward() {
        return this.currentReward;
    }

    public void setCurrentReward(Double d) {
        this.currentReward = d;
    }

    public ACTION_TYPE getPreviousAction() {
        return this.previousAction;
    }

    public void setPreviousAction(ACTION_TYPE ACTION_TYPE) {
        this.previousAction = ACTION_TYPE;
    }

    public STATE_TYPE getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(STATE_TYPE STATE_TYPE) {
        this.previousState = STATE_TYPE;
    }

    public STATE_TYPE getCurrentState() {
        return this.currentState;
    }
}

