/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.framework.Example;
import aima.learning.neural.Numerizer;
import aima.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IrisDataSetNumerizer
implements Numerizer {
    @Override
    public Pair<List<Double>, List<Double>> numerize(Example example) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<Object> list = new ArrayList();
        double d = example.getAttributeValueAsDouble("sepal_length");
        double d2 = example.getAttributeValueAsDouble("sepal_width");
        double d3 = example.getAttributeValueAsDouble("petal_length");
        double d4 = example.getAttributeValueAsDouble("petal_width");
        arrayList.add(d);
        arrayList.add(d2);
        arrayList.add(d3);
        arrayList.add(d4);
        String string = example.getAttributeValueAsString("plant_category");
        list = this.convertCategoryToListOfDoubles(string);
        Pair<List<Double>, List<Double>> pair = new Pair<List<Double>, List<Double>>(arrayList, list);
        return pair;
    }

    @Override
    public String denumerize(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Double d : list) {
            arrayList.add(this.round(d));
        }
        if (((Object)arrayList).equals(Arrays.asList(0.0, 0.0, 1.0))) {
            return "setosa";
        }
        if (((Object)arrayList).equals(Arrays.asList(0.0, 1.0, 0.0))) {
            return "versicolor";
        }
        if (((Object)arrayList).equals(Arrays.asList(1.0, 0.0, 0.0))) {
            return "virginica";
        }
        return "unknown";
    }

    private double round(Double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        return Math.round(d);
    }

    private List<Double> convertCategoryToListOfDoubles(String string) {
        if (string.equals("setosa")) {
            return Arrays.asList(0.0, 0.0, 1.0);
        }
        if (string.equals("versicolor")) {
            return Arrays.asList(0.0, 1.0, 0.0);
        }
        if (string.equals("virginica")) {
            return Arrays.asList(1.0, 0.0, 0.0);
        }
        throw new RuntimeException("invalid plant category");
    }
}

