/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.gui.applications.search.map.AbstractMapAgentController;
import aima.gui.applications.search.map.MapAgentFrame;
import aima.gui.applications.search.map.MapAgentModel;
import aima.gui.framework.AgentAppController;
import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentAppModel;
import aima.gui.framework.SimpleAgentAppDemo;
import aima.search.framework.SearchFactory;
import aima.search.map.AdaptableHeuristicFunction;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.map.Point2D;
import aima.search.map.Scenario;
import aima.search.map.SimplifiedRoadMapOfAustralia;
import aima.search.map.SimplifiedRoadMapOfPartOfRomania;
import java.util.ArrayList;

public class RoutePlanningAgentAppDemo
extends SimpleAgentAppDemo {
    @Override
    public AgentAppModel createModel() {
        return new MapAgentModel();
    }

    @Override
    public AgentAppFrame createFrame() {
        return new RoutePlanningAgentFrame();
    }

    @Override
    public AgentAppController createController() {
        return new RoutePlanningAgentController();
    }

    public static void main(String[] stringArray) {
        new RoutePlanningAgentAppDemo().startApplication();
    }

    static class H2
    extends AdaptableHeuristicFunction {
        H2() {
        }

        @Override
        public double getHeuristicValue(Object object) {
            double d = 0.0;
            Point2D point2D = this.map.getPosition((String)object);
            Point2D point2D2 = this.map.getPosition((String)this.goal);
            if (point2D != null && point2D2 != null) {
                d = point2D.distance(point2D2);
            }
            return d;
        }
    }

    static class H1
    extends AdaptableHeuristicFunction {
        H1() {
        }

        @Override
        public double getHeuristicValue(Object object) {
            return 0.0;
        }
    }

    protected static class RoutePlanningAgentController
    extends AbstractMapAgentController {
        protected RoutePlanningAgentController() {
        }

        @Override
        protected void selectScenarioAndDest(int n, int n2) {
            ExtendableMap extendableMap = new ExtendableMap();
            MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
            String string = null;
            switch (n) {
                case 0: {
                    SimplifiedRoadMapOfPartOfRomania.initMap(extendableMap);
                    string = "Arad";
                    break;
                }
                case 1: {
                    SimplifiedRoadMapOfPartOfRomania.initMap(extendableMap);
                    string = "Lugoj";
                    break;
                }
                case 2: {
                    SimplifiedRoadMapOfPartOfRomania.initMap(extendableMap);
                    string = "Fagaras";
                    break;
                }
                case 3: {
                    SimplifiedRoadMapOfAustralia.initMap(extendableMap);
                    string = "Sydney";
                    break;
                }
                case 4: {
                    SimplifiedRoadMapOfAustralia.initMap(extendableMap);
                    string = extendableMap.randomlyGenerateDestination();
                }
            }
            this.scenario = new Scenario(mapEnvironment, extendableMap, string);
            this.destinations = new ArrayList();
            if (n < 3) {
                switch (n2) {
                    case 0: {
                        this.destinations.add("Bucharest");
                        break;
                    }
                    case 1: {
                        this.destinations.add("Eforie");
                        break;
                    }
                    case 2: {
                        this.destinations.add("Neamt");
                        break;
                    }
                    case 3: {
                        this.destinations.add(extendableMap.randomlyGenerateDestination());
                    }
                }
            } else {
                switch (n2) {
                    case 0: {
                        this.destinations.add("PortHedland");
                        break;
                    }
                    case 1: {
                        this.destinations.add("Albany");
                        break;
                    }
                    case 2: {
                        this.destinations.add("Melbourne");
                        break;
                    }
                    case 3: {
                        this.destinations.add(extendableMap.randomlyGenerateDestination());
                    }
                }
            }
        }

        @Override
        protected void prepareModel() {
            ((MapAgentModel)this.model).prepare(this.scenario, this.destinations);
        }

        @Override
        protected AdaptableHeuristicFunction createHeuristic(int n) {
            switch (n) {
                case 0: {
                    return new H1();
                }
            }
            return new H2();
        }

        @Override
        protected void startAgent() {
            if (this.destinations.size() != 1) {
                this.frame.logMessage("Error: This agent requires exact one destination.");
                return;
            }
            this.frame.logMessage("<route-planning-simulation-protocol>");
            this.frame.logMessage("search: " + this.search.getClass().getName());
            MapEnvironment mapEnvironment = this.scenario.getEnv();
            String string = (String)this.destinations.get(0);
            MapAgent mapAgent = new MapAgent(mapEnvironment, this.search, new String[]{string});
            if (this.heuristic != null) {
                this.frame.logMessage("heuristic: " + this.heuristic.getClass().getName());
                mapAgent.setHeuristicFunction(this.heuristic.getAdaptation(string, this.scenario.getAgentMap()));
            }
            mapEnvironment.addAgent(mapAgent, this.scenario.getInitAgentLocation());
            mapEnvironment.stepUntilDone();
            this.frame.logMessage("</route-planning-simulation-protocol>\n");
        }
    }

    protected static class RoutePlanningAgentFrame
    extends MapAgentFrame {
        private MapType usedMap = null;
        private static String[] ROMANIA_DESTS = new String[]{"D1 (to Bucharest)", "D2 (to Eforie)", "D3 (to Neamt)", "D4 (to random)"};
        private static String[] AUSTRALIA_DESTS = new String[]{"D1 (to Port Hedland)", "D2 (to Albany)", "D3 (to Melbourne)", "D4 (to random)"};

        public RoutePlanningAgentFrame() {
            this.setTitle("RPA - the Route Planning Agent");
            this.setSelectorItems(SCENARIO_SEL, new String[]{"S1 (Romania, from Arad)", "S2 (Romania, from Lugoj)", "S3 (Romania, from Fagaras)", "S4 (Australia, from Sydney)", "S4 (Australia, from Random)"}, 0);
            this.setSelectorItems(SEARCH_MODE_SEL, SearchFactory.getInstance().getSearchModeNames(), 1);
            this.setSelectorItems(HEURISTIC_SEL, new String[]{"H1 (=0)", "H2 (sld to goal)"}, 1);
        }

        @Override
        protected void selectionChanged() {
            MapType mapType;
            AgentAppFrame.SelectionState selectionState = this.getSelection();
            int n = selectionState.getValue(MapAgentFrame.SCENARIO_SEL);
            MapType mapType2 = mapType = n < 3 ? MapType.ROMANIA : MapType.AUSTRALIA;
            if (mapType != this.usedMap) {
                this.usedMap = mapType;
                String[] stringArray = null;
                switch (mapType) {
                    case ROMANIA: {
                        stringArray = ROMANIA_DESTS;
                        break;
                    }
                    case AUSTRALIA: {
                        stringArray = AUSTRALIA_DESTS;
                    }
                }
                this.setSelectorItems(DESTINATION_SEL, stringArray, 0);
            }
            super.selectionChanged();
        }

        public static enum MapType {
            ROMANIA,
            AUSTRALIA;

        }
    }
}

