/*
 * Decompiled with CFR 0.152.
 */
package aima.basic;

import aima.basic.Agent;
import aima.basic.BasicEnvironmentView;
import aima.basic.EnvironmentObject;
import aima.basic.ObjectWithDynamicAttributes;
import aima.basic.Percept;
import java.util.ArrayList;
import java.util.List;

public abstract class Environment {
    protected ArrayList<EnvironmentObject> objects;
    protected ArrayList<Agent> agents = new ArrayList();
    protected ArrayList<BasicEnvironmentView> views;

    public abstract void executeAction(Agent var1, String var2);

    public abstract Percept getPerceptSeenBy(Agent var1);

    protected Environment() {
        this.objects = new ArrayList();
        this.views = new ArrayList();
    }

    public void registerView(BasicEnvironmentView basicEnvironmentView) {
        this.views.add(basicEnvironmentView);
    }

    public void updateViews(String string) {
        for (BasicEnvironmentView basicEnvironmentView : this.views) {
            basicEnvironmentView.envChanged(string);
        }
    }

    public boolean isDone() {
        for (Agent agent : this.agents) {
            if (!agent.isAlive()) continue;
            return false;
        }
        return true;
    }

    public void createExogenousChange() {
    }

    public void step() {
        if (!this.isDone()) {
            for (Agent agent : this.agents) {
                String string = agent.execute(this.getPerceptSeenBy(agent));
                this.updateViews(string);
                this.executeAction(agent, string);
            }
            this.createExogenousChange();
        }
    }

    public void step(int n) {
        for (int i = 0; i < n; ++i) {
            this.step();
        }
    }

    public void stepUntilDone() {
        while (!this.isDone()) {
            this.step();
        }
    }

    public ArrayList getAgents() {
        return this.agents;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public boolean alreadyContains(EnvironmentObject environmentObject) {
        boolean bl = false;
        for (EnvironmentObject environmentObject2 : this.objects) {
            if (!environmentObject2.equals(environmentObject)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean alreadyContains(Agent agent) {
        boolean bl = false;
        for (Agent agent2 : this.agents) {
            if (!agent2.equals(agent)) continue;
            bl = true;
        }
        return bl;
    }

    public void addAgent(Agent agent, String string, Object object) {
        if (!this.alreadyContains(agent)) {
            agent.setAttribute(string, object);
            this.agents.add(agent);
        }
    }

    public void addObject(EnvironmentObject environmentObject, String string, Object object) {
        if (!this.alreadyContains(environmentObject)) {
            environmentObject.setAttribute(string, object);
            this.objects.add(environmentObject);
        }
    }

    public void addObject(EnvironmentObject environmentObject) {
        if (!this.alreadyContains(environmentObject)) {
            this.objects.add(environmentObject);
        }
    }

    public void addAgent(Agent agent) {
        if (!this.alreadyContains(agent)) {
            this.agents.add(agent);
        }
    }

    public List<ObjectWithDynamicAttributes> getAllObjects() {
        ArrayList<ObjectWithDynamicAttributes> arrayList = new ArrayList<ObjectWithDynamicAttributes>();
        arrayList.addAll(this.objects);
        arrayList.addAll(this.agents);
        return arrayList;
    }
}

