/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class LabeledGraph<VertexLabelType, EdgeLabelType> {
    private final Hashtable<VertexLabelType, Hashtable<VertexLabelType, EdgeLabelType>> globalEdgeLookup = new Hashtable();
    private final List<VertexLabelType> vertexLabels = new ArrayList<VertexLabelType>();

    public void addVertex(VertexLabelType VertexLabelType) {
        this.checkForNewVertex(VertexLabelType);
    }

    public void set(VertexLabelType VertexLabelType, VertexLabelType VertexLabelType2, EdgeLabelType EdgeLabelType) {
        Hashtable<VertexLabelType, EdgeLabelType> hashtable = this.checkForNewVertex(VertexLabelType);
        hashtable.put(VertexLabelType2, EdgeLabelType);
        this.checkForNewVertex(VertexLabelType2);
    }

    private Hashtable<VertexLabelType, EdgeLabelType> checkForNewVertex(VertexLabelType VertexLabelType) {
        Hashtable<Object, Object> hashtable = this.globalEdgeLookup.get(VertexLabelType);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.globalEdgeLookup.put(VertexLabelType, hashtable);
            this.vertexLabels.add(VertexLabelType);
        }
        return hashtable;
    }

    public void remove(VertexLabelType VertexLabelType, VertexLabelType VertexLabelType2) {
        Hashtable<VertexLabelType, EdgeLabelType> hashtable = this.globalEdgeLookup.get(VertexLabelType);
        if (hashtable != null) {
            hashtable.remove(VertexLabelType2);
        }
    }

    public EdgeLabelType get(VertexLabelType VertexLabelType, VertexLabelType VertexLabelType2) {
        Hashtable<VertexLabelType, EdgeLabelType> hashtable = this.globalEdgeLookup.get(VertexLabelType);
        return hashtable == null ? null : (EdgeLabelType)hashtable.get(VertexLabelType2);
    }

    public List<VertexLabelType> getSuccessors(VertexLabelType VertexLabelType) {
        ArrayList<VertexLabelType> arrayList = new ArrayList<VertexLabelType>();
        Hashtable<VertexLabelType, EdgeLabelType> hashtable = this.globalEdgeLookup.get(VertexLabelType);
        if (hashtable != null) {
            arrayList.addAll(hashtable.keySet());
        }
        return arrayList;
    }

    public List<VertexLabelType> getVertexLabels() {
        return this.vertexLabels;
    }

    public boolean isVertexLabel(VertexLabelType VertexLabelType) {
        return this.globalEdgeLookup.get(VertexLabelType) != null;
    }

    public void clear() {
        this.vertexLabels.clear();
        this.globalEdgeLookup.clear();
    }
}

