/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.DepthFirstSearch;
import java.util.List;
import junit.framework.TestCase;

public class DepthFirstSearchTest
extends TestCase {
    public void testDepthFirstSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch(new GraphSearch());
        SearchAgent searchAgent = new SearchAgent(problem, depthFirstSearch);
        List list = searchAgent.getActions();
        this.assertCorrectPlacement(list);
        DepthFirstSearchTest.assertEquals((String)"113", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
    }

    public void testDepthFirstUnSuccessfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch(new GraphSearch());
        SearchAgent searchAgent = new SearchAgent(problem, depthFirstSearch);
        List list = searchAgent.getActions();
        DepthFirstSearchTest.assertEquals((int)0, (int)list.size());
        DepthFirstSearchTest.assertEquals((String)"6", (String)searchAgent.getInstrumentation().getProperty("nodesExpanded"));
    }

    private void assertCorrectPlacement(List list) {
        DepthFirstSearchTest.assertEquals((int)8, (int)list.size());
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 0  7", list.get(0));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 1  3", list.get(1));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 2  0", list.get(2));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 3  2", list.get(3));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 4  5", list.get(4));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 5  1", list.get(5));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 6  6", list.get(6));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 7  4", list.get(7));
    }
}

