/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.Search;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.uninformed.BidirectionalSearch;
import junit.framework.TestCase;

public class BidirectionalSearchTest
extends TestCase {
    StringBuffer envChanges;
    BidirectionalSearch bidirectionalSearch;

    public void setUp() {
        this.envChanges = new StringBuffer();
        this.bidirectionalSearch = new BidirectionalSearch();
    }

    public void test_A_StartingAtGoal() {
        ExtendableMap extendableMap = new ExtendableMap();
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"A"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(A):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=0:METRIC[nodesExpanded]=2:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABC_StartingAtGoal() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"A"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(A):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=2:METRIC[nodesExpanded]=2:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_AB_BothWaysPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"B"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(B):B:METRIC[pathCost]=5.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=2:METRIC[nodesExpanded]=2:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABC_BothWaysPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"C"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(C):B:C:METRIC[pathCost]=10.0:METRIC[maxQueueSize]=4:METRIC[queueSize]=4:METRIC[nodesExpanded]=4:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABCD_BothWaysPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        extendableMap.addBidirectionalLink("C", "D", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"D"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(D):B:C:D:METRIC[pathCost]=15.0:METRIC[maxQueueSize]=4:METRIC[queueSize]=4:METRIC[nodesExpanded]=4:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_AB_OriginalOnlyPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addUnidirectionalLink("A", "B", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"B"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(B):B:METRIC[pathCost]=5.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=1:METRIC[nodesExpanded]=2:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABC_OriginalOnlyPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addUnidirectionalLink("A", "B", 5.0);
        extendableMap.addUnidirectionalLink("B", "C", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"C"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(C):B:C:METRIC[pathCost]=10.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=0:METRIC[nodesExpanded]=4:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABCDE_OriginalOnlyPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addUnidirectionalLink("B", "C", 5.0);
        extendableMap.addBidirectionalLink("C", "D", 5.0);
        extendableMap.addBidirectionalLink("D", "E", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"E"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(E):B:C:D:E:METRIC[pathCost]=20.0:METRIC[maxQueueSize]=4:METRIC[queueSize]=3:METRIC[nodesExpanded]=5:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_AB_ReverseOnlyPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addUnidirectionalLink("B", "A", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"B"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(B):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=0:METRIC[nodesExpanded]=3:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_NOT_FOUND), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABC_ReverseOnlyPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addUnidirectionalLink("B", "A", 5.0);
        extendableMap.addUnidirectionalLink("C", "B", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"C"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(C):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=2:METRIC[queueSize]=0:METRIC[nodesExpanded]=4:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_NOT_FOUND), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABCDE_ReverseOnlyPath() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        extendableMap.addUnidirectionalLink("D", "C", 5.0);
        extendableMap.addUnidirectionalLink("E", "D", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"E"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(E):NoOP:METRIC[pathCost]=0.0:METRIC[maxQueueSize]=3:METRIC[queueSize]=0:METRIC[nodesExpanded]=8:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_NOT_FOUND), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABCDEF_OriginalFirst() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        extendableMap.addBidirectionalLink("C", "D", 5.0);
        extendableMap.addBidirectionalLink("D", "E", 5.0);
        extendableMap.addBidirectionalLink("E", "F", 5.0);
        extendableMap.addUnidirectionalLink("B", "F", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"F"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(F):B:F:METRIC[pathCost]=10.0:METRIC[maxQueueSize]=5:METRIC[queueSize]=5:METRIC[nodesExpanded]=6:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_FROM_ORIGINAL_PROBLEM), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABCDEF_ReverseFirstButNotFromOriginal() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        extendableMap.addBidirectionalLink("C", "D", 5.0);
        extendableMap.addBidirectionalLink("D", "E", 5.0);
        extendableMap.addBidirectionalLink("E", "F", 5.0);
        extendableMap.addUnidirectionalLink("E", "A", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"F"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(F):B:C:D:E:F:METRIC[pathCost]=25.0:METRIC[maxQueueSize]=6:METRIC[queueSize]=6:METRIC[nodesExpanded]=7:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }

    public void test_ABCDEF_MoreComplexReverseFirstButNotFromOriginal() {
        ExtendableMap extendableMap = new ExtendableMap();
        extendableMap.addBidirectionalLink("A", "B", 5.0);
        extendableMap.addBidirectionalLink("B", "C", 5.0);
        extendableMap.addBidirectionalLink("C", "D", 5.0);
        extendableMap.addBidirectionalLink("D", "E", 5.0);
        extendableMap.addUnidirectionalLink("F", "E", 5.0);
        extendableMap.addBidirectionalLink("E", "A", 5.0);
        extendableMap.addBidirectionalLink("D", "F", 5.0);
        MapEnvironment mapEnvironment = new MapEnvironment(extendableMap);
        MapAgent mapAgent = new MapAgent(mapEnvironment, (Search)this.bidirectionalSearch, new String[]{"F"});
        mapEnvironment.addAgent(mapAgent, "A");
        mapEnvironment.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String string) {
                BidirectionalSearchTest.this.envChanges.append(string).append(":");
            }
        });
        mapEnvironment.stepUntilDone();
        BidirectionalSearchTest.assertEquals((String)"CurrentLocation=In(A), Goal=In(F):B:C:D:F:METRIC[pathCost]=20.0:METRIC[maxQueueSize]=9:METRIC[queueSize]=9:METRIC[nodesExpanded]=7:NoOP:", (String)this.envChanges.toString());
        BidirectionalSearchTest.assertEquals((Object)((Object)BidirectionalSearch.SearchOutcome.PATH_FOUND_BETWEEN_PROBLEMS), (Object)((Object)this.bidirectionalSearch.getSearchOutcome()));
    }
}

