/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probabilitytest;

import aima.probability.BayesNet;
import aima.probability.BayesNetNode;
import java.util.List;
import junit.framework.TestCase;

public class BayesNetTest
extends TestCase {
    BayesNet net;

    public void setUp() {
        this.net = this.createBurglaryNetwork();
    }

    public void testVariablesAreCorrectlyObtainedFromBayesNetwork() {
        List<String> list = this.net.getVariables();
        BayesNetTest.assertEquals((int)5, (int)list.size());
        BayesNetTest.assertEquals((String)"Burglary", (String)list.get(0));
        BayesNetTest.assertEquals((String)"EarthQuake", (String)list.get(1));
        BayesNetTest.assertEquals((String)"Alarm", (String)list.get(2));
        BayesNetTest.assertEquals((String)"JohnCalls", (String)list.get(3));
        BayesNetTest.assertEquals((String)"MaryCalls", (String)list.get(4));
    }

    private BayesNet createBurglaryNetwork() {
        BayesNetNode bayesNetNode = new BayesNetNode("Burglary");
        BayesNetNode bayesNetNode2 = new BayesNetNode("EarthQuake");
        BayesNetNode bayesNetNode3 = new BayesNetNode("Alarm");
        BayesNetNode bayesNetNode4 = new BayesNetNode("JohnCalls");
        BayesNetNode bayesNetNode5 = new BayesNetNode("MaryCalls");
        bayesNetNode3.influencedBy(bayesNetNode, bayesNetNode2);
        bayesNetNode4.influencedBy(bayesNetNode3);
        bayesNetNode5.influencedBy(bayesNetNode3);
        bayesNetNode.setProbability(true, 0.001);
        bayesNetNode2.setProbability(true, 0.002);
        bayesNetNode3.setProbability(true, true, 0.95);
        bayesNetNode3.setProbability(true, false, 0.94);
        bayesNetNode3.setProbability(false, true, 0.29);
        bayesNetNode3.setProbability(false, false, 0.001);
        bayesNetNode4.setProbability(true, 0.9);
        bayesNetNode4.setProbability(false, 0.05);
        bayesNetNode5.setProbability(true, 0.7);
        bayesNetNode5.setProbability(false, 0.01);
        BayesNet bayesNet = new BayesNet(bayesNetNode, bayesNetNode2);
        return bayesNet;
    }
}

