/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import java.util.Set;
import junit.framework.TestCase;

public class CNFClauseGathererTest
extends TestCase {
    private CNFClauseGatherer gatherer;
    private PEParser parser;

    public void setUp() {
        this.parser = new PEParser();
        this.gatherer = new CNFClauseGatherer();
    }

    public void testSymbol() {
        Sentence sentence = (Sentence)this.parser.parse("A");
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Set<Sentence> set = this.gatherer.getClausesFrom(sentence);
        CNFClauseGathererTest.assertNotNull(set);
        CNFClauseGathererTest.assertEquals((int)1, (int)set.size());
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence2));
    }

    public void testNotSentence() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT A)");
        Sentence sentence2 = (Sentence)this.parser.parse("(NOT A)");
        Set<Sentence> set = this.gatherer.getClausesFrom(sentence);
        CNFClauseGathererTest.assertNotNull(set);
        CNFClauseGathererTest.assertEquals((int)1, (int)set.size());
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence2));
    }

    public void testSimpleAndClause() {
        Sentence sentence = (Sentence)this.parser.parse("(A AND B)");
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Sentence sentence3 = (Sentence)this.parser.parse("B");
        Set<Sentence> set = this.gatherer.getClausesFrom(sentence);
        CNFClauseGathererTest.assertEquals((int)2, (int)set.size());
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence2));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence3));
    }

    public void testMultiAndClause() {
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND C)");
        Set<Sentence> set = this.gatherer.getClausesFrom(sentence);
        CNFClauseGathererTest.assertEquals((int)3, (int)set.size());
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Sentence sentence3 = (Sentence)this.parser.parse("B");
        Sentence sentence4 = (Sentence)this.parser.parse("C");
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence2));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence3));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence4));
    }

    public void testMultiAndClause2() {
        Sentence sentence = (Sentence)this.parser.parse("(A AND (B AND C))");
        Set<Sentence> set = this.gatherer.getClausesFrom(sentence);
        CNFClauseGathererTest.assertEquals((int)3, (int)set.size());
        Sentence sentence2 = (Sentence)this.parser.parse("A");
        Sentence sentence3 = (Sentence)this.parser.parse("B");
        Sentence sentence4 = (Sentence)this.parser.parse("C");
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence2));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence3));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence4));
    }

    public void testAimaExample() {
        Sentence sentence = (Sentence)this.parser.parse("( B11 <=> (P12 OR P21))");
        CNFTransformer cNFTransformer = new CNFTransformer();
        Sentence sentence2 = cNFTransformer.transform(sentence);
        Set<Sentence> set = this.gatherer.getClausesFrom(sentence2);
        Sentence sentence3 = (Sentence)this.parser.parse("( B11 OR  ( NOT P12 )  )");
        Sentence sentence4 = (Sentence)this.parser.parse("( B11 OR  ( NOT P21 )  )");
        Sentence sentence5 = (Sentence)this.parser.parse("(  ( NOT B11 )  OR  ( P12 OR P21 ) )");
        CNFClauseGathererTest.assertEquals((int)3, (int)set.size());
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence3));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence4));
        CNFClauseGathererTest.assertTrue((boolean)set.contains(sentence5));
    }
}

