/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Sentence;
import junit.framework.TestCase;

public class CNFConverterTest
extends TestCase {
    public void testExamplePg295() {
        FOLDomain fOLDomain = DomainFactory.weaponsDomain();
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("FORALL x ((((American(x) AND Weapon(y)) AND Sells(x, y, z)) AND Hostile(z)) => Criminal(x))");
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~American(x), ~Hostile(z), ~Sells(x,y,z), ~Weapon(y), Criminal(x)]", (String)cNF.toString());
    }

    public void testExamplePg296() {
        FOLDomain fOLDomain = DomainFactory.lovesAnimalDomain();
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[Animal(SF0(x)), Loves(SF1(x),x)],[~Loves(x,SF0(x)), Loves(SF1(x),x)]", (String)cNF.toString());
    }

    public void testExamplesPg299() {
        FOLDomain fOLDomain = DomainFactory.lovesAnimalDomain();
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[Animal(SF0(x)), Loves(SF1(x),x)],[~Loves(x,SF0(x)), Loves(SF1(x),x)]", (String)cNF.toString());
        sentence = fOLParser.parse("FORALL x (EXISTS y (Animal(y) AND Kills(x, y)) => FORALL z NOT(Loves(z, x)))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Animal(y), ~Kills(x,y), ~Loves(z,x)]", (String)cNF.toString());
        sentence = fOLParser.parse("FORALL x (Animal(x) => Loves(Jack, x))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Animal(x), Loves(Jack,x)]", (String)cNF.toString());
        sentence = fOLParser.parse("(Kills(Jack, Tuna) OR Kills(Curiosity, Tuna))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[Kills(Curiosity,Tuna), Kills(Jack,Tuna)]", (String)cNF.toString());
        sentence = fOLParser.parse("Cat(Tuna)");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[Cat(Tuna)]", (String)cNF.toString());
        sentence = fOLParser.parse("FORALL x (Cat(x) => Animal(x))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Cat(x), Animal(x)]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(Kills(Curiosity, Tuna))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Kills(Curiosity,Tuna)]", (String)cNF.toString());
    }

    public void testNestedExistsAndOrs() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("R");
        fOLDomain.addPredicate("Q");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        Sentence sentence = fOLParser.parse("EXISTS w (FORALL x ( (EXISTS z (Q(w, z))) => (EXISTS y (NOT(P(x, y)) AND R(y))) ) )");
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~P(x,SF0(x)), ~Q(SC0,z)],[~Q(SC0,z), R(SF0(x))]", (String)cNF.toString());
        sentence = fOLParser.parse("FORALL x1 (FORALL y1 (P(x1, y1) => EXISTS z1 (Q(x1, y1, z1))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~P(x1,y1), Q(x1,y1,SF1(x1,y1))]", (String)cNF.toString());
        sentence = fOLParser.parse("EXISTS x2 (FORALL y2 (FORALL z2 (R(y2, z2) <=> Q(x2, y2, z2))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~R(y2,z2), Q(SC1,y2,z2)],[~Q(SC1,y2,z2), R(y2,z2)]", (String)cNF.toString());
        sentence = fOLParser.parse("FORALL x3 (EXISTS y3 (NOT(P(x3, y3)) => FORALL z3 (Q(x3, y3, z3))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[P(x3,SF2(x3)), Q(x3,SF2(x3),z3)]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(EXISTS w4 (EXISTS x4 (EXISTS y4 ( EXISTS z4 (R(x4, y4) AND Q(x4, w4, z4))))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Q(x4,w4,z4), ~R(x4,y4)]", (String)cNF.toString());
    }

    public void testImplicationsAndExtendedAndsOrs() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("Cheat");
        fOLDomain.addPredicate("Extra");
        fOLDomain.addPredicate("Knows");
        fOLDomain.addPredicate("Diff");
        fOLDomain.addPredicate("F");
        fOLDomain.addPredicate("A");
        fOLDomain.addPredicate("Probation");
        fOLDomain.addPredicate("Award");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        Sentence sentence = fOLParser.parse("(Cheat(x,y) => F(x,y))");
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Cheat(x,y), F(x,y)]", (String)cNF.toString());
        Sentence sentence2 = fOLParser.parse("((Extra(x,y) OR Knows(x)) => A(x,y))");
        CNF cNF2 = cNFConverter.convertToCNF(sentence2);
        CNFConverterTest.assertEquals((String)"[~Extra(x,y), A(x,y)],[~Knows(x), A(x,y)]", (String)cNF2.toString());
        Sentence sentence3 = fOLParser.parse("(((NOT(((F(x,y) AND F(x,z)) AND Diff(y,z)))) OR Probation(x)) AND (((F(x,y) AND F(x,z)) AND Diff(y,z)) OR NOT(Probation(x))))");
        CNF cNF3 = cNFConverter.convertToCNF(sentence3);
        CNFConverterTest.assertEquals((String)"[~Diff(y,z), ~F(x,y), ~F(x,z), Probation(x)],[~Probation(x), F(x,y)],[~Probation(x), F(x,z)],[~Probation(x), Diff(y,z)]", (String)cNF3.toString());
        Sentence sentence4 = fOLParser.parse("(((NOT(((A(x,y) AND A(x,z)) AND Diff(y,z)))) OR Award(x)) AND (((A(x,y) AND A(x,z)) AND Diff(y,z)) OR NOT(Award(x))))");
        CNF cNF4 = cNFConverter.convertToCNF(sentence4);
        CNFConverterTest.assertEquals((String)"[~A(x,y), ~A(x,z), ~Diff(y,z), Award(x)],[~Award(x), A(x,y)],[~Award(x), A(x,z)],[~Award(x), Diff(y,z)]", (String)cNF4.toString());
        Sentence sentence5 = fOLParser.parse("( ( NOT(F(x,y)) OR NOT(A(x,y))) AND ( F(x,y) OR NOT(NOT(A(x,y))) ) )");
        CNF cNF5 = cNFConverter.convertToCNF(sentence5);
        CNFConverterTest.assertEquals((String)"[~A(x,y), ~F(x,y)],[A(x,y), F(x,y)]", (String)cNF5.toString());
    }

    public void testNegationsAndNestedImplications() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        fOLDomain.addPredicate("R");
        fOLDomain.addConstant("A");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        Sentence sentence = fOLParser.parse("NOT(((((NOT(P(A)) OR NOT(Q(A)))) => NOT((P(A) OR Q(A)))) => R(A)))");
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~P(A), P(A)],[~P(A), Q(A)],[~Q(A), P(A)],[~Q(A), Q(A)],[~R(A)]", (String)cNF.toString());
    }

    public void testInductionAxiomSchema() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("Equal");
        fOLDomain.addFunction("Plus");
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("N");
        fOLDomain.addConstant("ONE");
        fOLDomain.addConstant("ZERO");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        Sentence sentence = fOLParser.parse("NOT(FORALL x (FORALL y (Equal(Plus(Plus(x,y),ZERO), Plus(x,Plus(y,ZERO))))))");
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Equal(Plus(Plus(SC0,SC1),ZERO),Plus(SC0,Plus(SC1,ZERO)))]", (String)cNF.toString());
        sentence = fOLParser.parse("((Equal(Plus(Plus(A,B),ZERO), Plus(A,Plus(B,ZERO))) AND (FORALL x (FORALL y (FORALL z(Equal(Plus(Plus(x,y),z), Plus(x,Plus(y,z))) => Equal(Plus(Plus(x,y),Plus(z,ONE)), Plus(x,Plus(y,Plus(z,ONE))))))))) => FORALL x (FORALL y (FORALL z(Equal(Plus(Plus(x,y),z), Plus(x,Plus(y,z)))))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Equal(Plus(Plus(A,B),ZERO),Plus(A,Plus(B,ZERO))), Equal(Plus(Plus(q0,q1),q2),Plus(q0,Plus(q1,q2))), Equal(Plus(Plus(SC2,SC3),SC4),Plus(SC2,Plus(SC3,SC4)))],[~Equal(Plus(Plus(A,B),ZERO),Plus(A,Plus(B,ZERO))), ~Equal(Plus(Plus(SC2,SC3),Plus(SC4,ONE)),Plus(SC2,Plus(SC3,Plus(SC4,ONE)))), Equal(Plus(Plus(q0,q1),q2),Plus(q0,Plus(q1,q2)))]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(FORALL x (FORALL y (FORALL z (Equal(Plus(Plus(x,y),z), Plus(x,Plus(y,z)))))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Equal(Plus(Plus(SC5,SC6),SC7),Plus(SC5,Plus(SC6,SC7)))]", (String)cNF.toString());
    }

    public void testTermEquality() {
        FOLDomain fOLDomain = new FOLDomain();
        fOLDomain.addPredicate("P");
        fOLDomain.addPredicate("Q");
        fOLDomain.addPredicate("R");
        fOLDomain.addConstant("A");
        fOLDomain.addConstant("B");
        fOLDomain.addConstant("C");
        fOLDomain.addConstant("D");
        fOLDomain.addFunction("Plus");
        fOLDomain.addConstant("ONE");
        fOLDomain.addConstant("ZERO");
        FOLParser fOLParser = new FOLParser(fOLDomain);
        CNFConverter cNFConverter = new CNFConverter(fOLParser);
        Sentence sentence = fOLParser.parse("x = y");
        CNF cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[x = y]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(x = y)");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~x = y]", (String)cNF.toString());
        sentence = fOLParser.parse("A = B");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[A = B]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(A = B)");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~A = B]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(((((NOT(A = B) OR NOT(D = C))) => NOT((A = B OR D = C))) => A = D))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~A = B, A = B],[~A = B, D = C],[~D = C, A = B],[~D = C, D = C],[~A = D]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(FORALL x (FORALL y (Plus(Plus(x,y),ZERO) = Plus(x,Plus(y,ZERO)))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Plus(Plus(SC0,SC1),ZERO) = Plus(SC0,Plus(SC1,ZERO))]", (String)cNF.toString());
        sentence = fOLParser.parse("((Plus(Plus(A,B),ZERO) = Plus(A,Plus(B,ZERO)) AND (FORALL x (FORALL y (FORALL z(Plus(Plus(x,y),z) = Plus(x,Plus(y,z)) => Plus(Plus(x,y),Plus(z,ONE)) = Plus(x,Plus(y,Plus(z,ONE)))))))) => FORALL x (FORALL y (FORALL z(Plus(Plus(x,y),z) = Plus(x,Plus(y,z))))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Plus(Plus(A,B),ZERO) = Plus(A,Plus(B,ZERO)), Plus(Plus(q0,q1),q2) = Plus(q0,Plus(q1,q2)), Plus(Plus(SC2,SC3),SC4) = Plus(SC2,Plus(SC3,SC4))],[~Plus(Plus(A,B),ZERO) = Plus(A,Plus(B,ZERO)), ~Plus(Plus(SC2,SC3),Plus(SC4,ONE)) = Plus(SC2,Plus(SC3,Plus(SC4,ONE))), Plus(Plus(q0,q1),q2) = Plus(q0,Plus(q1,q2))]", (String)cNF.toString());
        sentence = fOLParser.parse("NOT(FORALL x (FORALL y (FORALL z (Plus(Plus(x,y),z) = Plus(x,Plus(y,z))))))");
        cNF = cNFConverter.convertToCNF(sentence);
        CNFConverterTest.assertEquals((String)"[~Plus(Plus(SC5,SC6),SC7) = Plus(SC5,Plus(SC6,SC7))]", (String)cNF.toString());
    }
}

