/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest.neural;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.neural.BackPropLearning;
import aima.learning.neural.FeedForwardNeuralNetwork;
import aima.learning.neural.IrisDataSetNumerizer;
import aima.learning.neural.IrisNNDataSet;
import aima.learning.neural.NNConfig;
import aima.learning.neural.Perceptron;
import aima.learning.neural.Vector;
import aima.util.Matrix;
import junit.framework.TestCase;

public class BackPropagationTests
extends TestCase {
    public void testFeedForwardAndBAckLoopWorks() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Vector vector4 = new Vector(1);
        vector4.setValue(0, 1.261);
        double d = 0.1;
        double d2 = 0.0;
        FeedForwardNeuralNetwork feedForwardNeuralNetwork = new FeedForwardNeuralNetwork(matrix, vector, matrix2, vector3);
        feedForwardNeuralNetwork.setTrainingScheme(new BackPropLearning(d, d2));
        feedForwardNeuralNetwork.processInput(vector2);
        feedForwardNeuralNetwork.processError(vector4);
        Matrix matrix3 = feedForwardNeuralNetwork.getHiddenLayerWeights();
        BackPropagationTests.assertEquals((double)-0.265, (double)matrix3.get(0, 0), (double)0.001);
        BackPropagationTests.assertEquals((double)-0.419, (double)matrix3.get(1, 0), (double)0.001);
        Vector vector5 = feedForwardNeuralNetwork.getHiddenLayerBias();
        BackPropagationTests.assertEquals((double)-0.475, (double)vector5.getValue(0), (double)0.001);
        BackPropagationTests.assertEquals((double)-0.1399, (double)vector5.getValue(1), (double)0.001);
        Matrix matrix4 = feedForwardNeuralNetwork.getOutputLayerWeights();
        BackPropagationTests.assertEquals((double)0.171, (double)matrix4.get(0, 0), (double)0.001);
        BackPropagationTests.assertEquals((double)-0.0772, (double)matrix4.get(0, 1), (double)0.001);
        Vector vector6 = feedForwardNeuralNetwork.getOutputLayerBias();
        BackPropagationTests.assertEquals((double)0.7322, (double)vector6.getValue(0), (double)0.001);
    }

    public void xtestFeedForwardAndBAckLoopWorksWithMomentum() {
        Matrix matrix = new Matrix(2, 1);
        matrix.set(0, 0, -0.27);
        matrix.set(1, 0, -0.41);
        Vector vector = new Vector(2);
        vector.setValue(0, -0.48);
        vector.setValue(1, -0.13);
        Vector vector2 = new Vector(1);
        vector2.setValue(0, 1.0);
        Matrix matrix2 = new Matrix(1, 2);
        matrix2.set(0, 0, 0.09);
        matrix2.set(0, 1, -0.17);
        Vector vector3 = new Vector(1);
        vector3.setValue(0, 0.48);
        Vector vector4 = new Vector(1);
        vector4.setValue(0, 1.261);
        double d = 0.1;
        double d2 = 0.5;
        FeedForwardNeuralNetwork feedForwardNeuralNetwork = new FeedForwardNeuralNetwork(matrix, vector, matrix2, vector3);
        feedForwardNeuralNetwork.setTrainingScheme(new BackPropLearning(d, d2));
        feedForwardNeuralNetwork.processInput(vector2);
        feedForwardNeuralNetwork.processError(vector4);
        Matrix matrix3 = feedForwardNeuralNetwork.getHiddenLayerWeights();
        BackPropagationTests.assertEquals((double)-0.2675, (double)matrix3.get(0, 0), (double)0.001);
        BackPropagationTests.assertEquals((double)-0.4149, (double)matrix3.get(1, 0), (double)0.001);
        Vector vector5 = feedForwardNeuralNetwork.getHiddenLayerBias();
        BackPropagationTests.assertEquals((double)-0.4775, (double)vector5.getValue(0), (double)0.001);
        BackPropagationTests.assertEquals((double)-0.1349, (double)vector5.getValue(1), (double)0.001);
        Matrix matrix4 = feedForwardNeuralNetwork.getOutputLayerWeights();
        BackPropagationTests.assertEquals((double)0.1304, (double)matrix4.get(0, 0), (double)0.001);
        BackPropagationTests.assertEquals((double)-0.1235, (double)matrix4.get(0, 1), (double)0.001);
        Vector vector6 = feedForwardNeuralNetwork.getOutputLayerBias();
        BackPropagationTests.assertEquals((double)0.6061, (double)vector6.getValue(0), (double)0.001);
    }

    public void xtestDataSetPopulation() throws Exception {
        DataSet dataSet = DataSetFactory.getIrisDataSet();
        IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
        IrisNNDataSet irisNNDataSet = new IrisNNDataSet();
        irisNNDataSet.createExamplesFromDataSet(dataSet, irisDataSetNumerizer);
        NNConfig nNConfig = new NNConfig();
        nNConfig.setConfig("number_of_inputs", 4);
        nNConfig.setConfig("number_of_outputs", 3);
        nNConfig.setConfig("number_of_hidden_neurons", 6);
        nNConfig.setConfig("lower_limit_weights", -2.0);
        nNConfig.setConfig("upper_limit_weights", 2.0);
        FeedForwardNeuralNetwork feedForwardNeuralNetwork = new FeedForwardNeuralNetwork(nNConfig);
        feedForwardNeuralNetwork.setTrainingScheme(new BackPropLearning(0.1, 0.9));
        feedForwardNeuralNetwork.trainOn(irisNNDataSet, 10);
        irisNNDataSet.refreshDataset();
        int[] nArray = feedForwardNeuralNetwork.testOnDataSet(irisNNDataSet);
    }

    public void testPerceptron() throws Exception {
        DataSet dataSet = DataSetFactory.getIrisDataSet();
        IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
        IrisNNDataSet irisNNDataSet = new IrisNNDataSet();
        irisNNDataSet.createExamplesFromDataSet(dataSet, irisDataSetNumerizer);
        Perceptron perceptron = new Perceptron(3, 4);
        perceptron.trainOn(irisNNDataSet, 10);
        irisNNDataSet.refreshDataset();
        int[] nArray = perceptron.testOnDataSet(irisNNDataSet);
    }
}

