/*
 * Decompiled with CFR 0.152.
 */
package aima.search.uninformed;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import java.util.ArrayList;
import java.util.List;

public class DepthLimitedSearch
extends NodeExpander
implements Search {
    private static String PATH_COST = "pathCost";
    private final int limit;

    public DepthLimitedSearch(int n) {
        this.limit = n;
    }

    @Override
    public List search(Problem problem) throws Exception {
        this.clearInstrumentation();
        return this.recursiveDLS(new Node(problem.getInitialState()), problem, this.limit);
    }

    private List recursiveDLS(Node node, Problem problem, int n) {
        boolean bl = false;
        if (problem.isGoalState(node.getState())) {
            this.setPathCost(node.getPathCost());
            return SearchUtils.actionsFromNodes(node.getPathFromRoot());
        }
        if (node.getDepth() == n) {
            return this.createCutOffResult();
        }
        List<Node> list = this.expandNode(node, problem);
        for (int i = 0; i < list.size(); ++i) {
            Node node2 = list.get(i);
            List list2 = this.recursiveDLS(node2, problem, n);
            if (this.cutoffResult(list2)) {
                bl = true;
                continue;
            }
            if (this.failure(list2)) continue;
            return list2;
        }
        if (bl) {
            return this.createCutOffResult();
        }
        return new ArrayList();
    }

    @Override
    public void clearInstrumentation() {
        super.clearInstrumentation();
        this.metrics.set(PATH_COST, 0);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double d) {
        this.metrics.set(PATH_COST, d);
    }

    private boolean failure(List list) {
        return list.size() == 0;
    }

    private boolean cutoffResult(List list) {
        return list.size() == 1 && list.get(0).equals("cutoff");
    }

    private List createCutOffResult() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cutoff");
        return arrayList;
    }
}

