/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.DefaultHeuristicFunction;
import aima.search.framework.DefaultStepCostFunction;
import aima.search.framework.GoalTest;
import aima.search.framework.HeuristicFunction;
import aima.search.framework.StepCostFunction;
import aima.search.framework.SuccessorFunction;

public class Problem {
    protected Object initialState;
    protected SuccessorFunction successorFunction;
    protected GoalTest goalTest;
    protected StepCostFunction stepCostFunction;
    protected HeuristicFunction heuristicFunction;

    protected Problem() {
    }

    public Problem(Object object, SuccessorFunction successorFunction, GoalTest goalTest) {
        this.initialState = object;
        this.successorFunction = successorFunction;
        this.goalTest = goalTest;
        this.stepCostFunction = new DefaultStepCostFunction();
        this.heuristicFunction = new DefaultHeuristicFunction();
    }

    public Problem(Object object, SuccessorFunction successorFunction, GoalTest goalTest, StepCostFunction stepCostFunction) {
        this(object, successorFunction, goalTest);
        this.stepCostFunction = stepCostFunction;
    }

    public Problem(Object object, SuccessorFunction successorFunction, GoalTest goalTest, HeuristicFunction heuristicFunction) {
        this(object, successorFunction, goalTest);
        this.heuristicFunction = heuristicFunction;
    }

    public Problem(Object object, SuccessorFunction successorFunction, GoalTest goalTest, StepCostFunction stepCostFunction, HeuristicFunction heuristicFunction) {
        this(object, successorFunction, goalTest, stepCostFunction);
        this.heuristicFunction = heuristicFunction;
    }

    public Object getInitialState() {
        return this.initialState;
    }

    public boolean isGoalState(Object object) {
        return this.goalTest.isGoalState(object);
    }

    public StepCostFunction getStepCostFunction() {
        return this.stepCostFunction;
    }

    public SuccessorFunction getSuccessorFunction() {
        return this.successorFunction;
    }

    public HeuristicFunction getHeuristicFunction() {
        return this.heuristicFunction;
    }
}

