/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class PLFCEntails {
    private Hashtable<HornClause, Integer> count = new Hashtable();
    private Hashtable<Symbol, Boolean> inferred = new Hashtable();
    private Stack<Symbol> agenda = new Stack();

    public boolean plfcEntails(KnowledgeBase knowledgeBase, String string) {
        return this.plfcEntails(knowledgeBase, new Symbol(string));
    }

    public boolean plfcEntails(KnowledgeBase knowledgeBase, Symbol symbol) {
        List<HornClause> list = this.asHornClauses(knowledgeBase.getSentences());
        while (this.agenda.size() != 0) {
            Symbol symbol2 = this.agenda.pop();
            while (!this.inferred(symbol2)) {
                this.inferred.put(symbol2, Boolean.TRUE);
                for (int i = 0; i < list.size(); ++i) {
                    HornClause hornClause = list.get(i);
                    if (!hornClause.premisesContainsSymbol(symbol2)) continue;
                    this.decrementCount(hornClause);
                    if (!this.countisZero(hornClause)) continue;
                    if (hornClause.head().equals(symbol)) {
                        return true;
                    }
                    this.agenda.push(hornClause.head());
                }
            }
        }
        return false;
    }

    private List<HornClause> asHornClauses(List list) {
        ArrayList<HornClause> arrayList = new ArrayList<HornClause>();
        for (int i = 0; i < list.size(); ++i) {
            Sentence sentence = (Sentence)list.get(i);
            HornClause hornClause = new HornClause(sentence);
            arrayList.add(hornClause);
        }
        return arrayList;
    }

    private boolean countisZero(HornClause hornClause) {
        return this.count.get(hornClause) == 0;
    }

    private void decrementCount(HornClause hornClause) {
        int n = this.count.get(hornClause);
        this.count.put(hornClause, new Integer(n - 1));
    }

    private boolean inferred(Symbol symbol) {
        Boolean bl = this.inferred.get(symbol);
        return bl == null || ((Object)bl).equals(Boolean.TRUE);
    }

    public class HornClause {
        List<Symbol> premiseSymbols;
        Symbol head;

        public HornClause(Sentence sentence) {
            if (sentence instanceof Symbol) {
                this.head = (Symbol)sentence;
                PLFCEntails.this.agenda.push(this.head);
                this.premiseSymbols = new ArrayList<Symbol>();
                PLFCEntails.this.count.put(this, new Integer(0));
                PLFCEntails.this.inferred.put(this.head, Boolean.FALSE);
            } else {
                if (!this.isImpliedSentence(sentence)) {
                    throw new RuntimeException("Sentence " + sentence + " is not a horn clause");
                }
                BinarySentence binarySentence = (BinarySentence)sentence;
                this.head = (Symbol)binarySentence.getSecond();
                PLFCEntails.this.inferred.put(this.head, Boolean.FALSE);
                Set<Symbol> set = new SymbolCollector().getSymbolsIn(binarySentence.getFirst());
                Iterator<Symbol> iterator = set.iterator();
                while (iterator.hasNext()) {
                    PLFCEntails.this.inferred.put(iterator.next(), Boolean.FALSE);
                }
                this.premiseSymbols = new Converter<Symbol>().setToList(set);
                PLFCEntails.this.count.put(this, new Integer(this.premiseSymbols.size()));
            }
        }

        private boolean isImpliedSentence(Sentence sentence) {
            return sentence instanceof BinarySentence && ((BinarySentence)sentence).getOperator().equals("=>");
        }

        public Symbol head() {
            return this.head;
        }

        public boolean premisesContainsSymbol(Symbol symbol) {
            return this.premiseSymbols.contains(symbol);
        }

        public List getPremiseSymbols() {
            return this.premiseSymbols;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HornClause hornClause = (HornClause)object;
            if (this.premiseSymbols.size() != hornClause.premiseSymbols.size()) {
                return false;
            }
            boolean bl = true;
            for (Symbol symbol : this.premiseSymbols) {
                if (hornClause.premiseSymbols.contains(symbol)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 17;
            for (Symbol symbol : this.premiseSymbols) {
                n = 37 * n + symbol.hashCode();
            }
            return n;
        }

        public String toString() {
            return this.premiseSymbols.toString() + " => " + this.head;
        }
    }
}

