/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStepBwChGoal;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FOLBCAsk
implements InferenceProcedure {
    @Override
    public InferenceResult ask(FOLKnowledgeBase fOLKnowledgeBase, Sentence sentence) {
        if (!(sentence instanceof AtomicSentence)) {
            throw new IllegalArgumentException("Only Atomic Queries are supported.");
        }
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        arrayList.add(new Literal((AtomicSentence)sentence));
        BCAskAnswerHandler bCAskAnswerHandler = new BCAskAnswerHandler();
        List<List<ProofStepBwChGoal>> list = this.folbcask(fOLKnowledgeBase, bCAskAnswerHandler, arrayList, new HashMap<Variable, Term>());
        bCAskAnswerHandler.setAllProofSteps(list);
        return bCAskAnswerHandler;
    }

    private List<List<ProofStepBwChGoal>> folbcask(FOLKnowledgeBase fOLKnowledgeBase, BCAskAnswerHandler bCAskAnswerHandler, List<Literal> list, Map<Variable, Term> map) {
        ArrayList<List<ProofStepBwChGoal>> arrayList = new ArrayList<List<ProofStepBwChGoal>>();
        if (list.isEmpty()) {
            arrayList.add(new ArrayList());
            return arrayList;
        }
        Literal literal = fOLKnowledgeBase.subst(map, list.get(0));
        for (Clause clause : fOLKnowledgeBase.getAllDefiniteClauses()) {
            Map<Variable, Term> map2 = fOLKnowledgeBase.unify((clause = fOLKnowledgeBase.standardizeApart(clause)).getPositiveLiterals().get(0).getAtomicSentence(), literal.getAtomicSentence());
            if (null == map2) continue;
            ArrayList<Literal> arrayList2 = new ArrayList<Literal>(clause.getNegativeLiterals());
            arrayList2.addAll(list.subList(1, list.size()));
            Map<Variable, Term> map3 = this.compose(fOLKnowledgeBase, map2, map);
            List<List<ProofStepBwChGoal>> list2 = this.folbcask(fOLKnowledgeBase, bCAskAnswerHandler, arrayList2, map3);
            bCAskAnswerHandler.addProofStep(list2, clause, literal, map3);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private Map<Variable, Term> compose(FOLKnowledgeBase fOLKnowledgeBase, Map<Variable, Term> map, Map<Variable, Term> map2) {
        HashMap<Variable, Term> hashMap = new HashMap<Variable, Term>();
        for (Variable variable : map.keySet()) {
            hashMap.put(variable, fOLKnowledgeBase.subst(map2, map.get(variable)));
        }
        for (Variable variable : map2.keySet()) {
            if (map.containsKey(variable)) continue;
            hashMap.put(variable, map2.get(variable));
        }
        return this.cascadeSubstitutions(fOLKnowledgeBase, hashMap);
    }

    private Map<Variable, Term> cascadeSubstitutions(FOLKnowledgeBase fOLKnowledgeBase, Map<Variable, Term> map) {
        for (Variable variable : map.keySet()) {
            Term term = map.get(variable);
            map.put(variable, fOLKnowledgeBase.subst(map, term));
        }
        return map;
    }

    class BCAskAnswerHandler
    implements InferenceResult {
        private List<Proof> proofs = new ArrayList<Proof>();

        @Override
        public boolean isPossiblyFalse() {
            return this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return false;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return false;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public void setAllProofSteps(List<List<ProofStepBwChGoal>> list) {
            for (List<ProofStepBwChGoal> list2 : list) {
                ProofStepBwChGoal proofStepBwChGoal = list2.get(list2.size() - 1);
                Map<Variable, Term> map = proofStepBwChGoal.getBindings();
                this.proofs.add(new ProofFinal(proofStepBwChGoal, map));
            }
        }

        public void addProofStep(List<List<ProofStepBwChGoal>> list, Clause clause, Literal literal, Map<Variable, Term> map) {
            if (list.size() > 0) {
                ProofStepBwChGoal proofStepBwChGoal = new ProofStepBwChGoal(clause, literal, map);
                for (List<ProofStepBwChGoal> list2 : list) {
                    if (list2.size() > 0) {
                        list2.get(0).setPredecessor(proofStepBwChGoal);
                    }
                    list2.add(0, proofStepBwChGoal);
                }
            }
        }
    }
}

