/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.domain;

import aima.logic.fol.domain.FOLDomainAnswerLiteralAddedEvent;
import aima.logic.fol.domain.FOLDomainEvent;
import aima.logic.fol.domain.FOLDomainListener;
import aima.logic.fol.domain.FOLDomainSkolemConstantAddedEvent;
import aima.logic.fol.domain.FOLDomainSkolemFunctionAddedEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FOLDomain {
    private Set<String> constants;
    private Set<String> functions;
    private Set<String> predicates;
    private int skolemConstantIndexical = 0;
    private int skolemFunctionIndexical = 0;
    private int answerLiteralIndexical = 0;
    private List<FOLDomainListener> listeners = new ArrayList<FOLDomainListener>();

    public FOLDomain() {
        this.constants = new HashSet<String>();
        this.functions = new HashSet<String>();
        this.predicates = new HashSet<String>();
    }

    public FOLDomain(FOLDomain fOLDomain) {
        this(fOLDomain.getConstants(), fOLDomain.getFunctions(), fOLDomain.getPredicates());
    }

    public FOLDomain(Set<String> set, Set<String> set2, Set<String> set3) {
        this.constants = new HashSet<String>(set);
        this.functions = new HashSet<String>(set2);
        this.predicates = new HashSet<String>(set3);
    }

    public Set<String> getConstants() {
        return this.constants;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public Set<String> getPredicates() {
        return this.predicates;
    }

    public void addConstant(String string) {
        this.constants.add(string);
    }

    public String addSkolemConstant() {
        String string = null;
        while (this.constants.contains(string = "SC" + this.skolemConstantIndexical++) || this.functions.contains(string) || this.predicates.contains(string)) {
        }
        this.addConstant(string);
        this.notifyFOLDomainListeners(new FOLDomainSkolemConstantAddedEvent(this, string));
        return string;
    }

    public void addFunction(String string) {
        this.functions.add(string);
    }

    public String addSkolemFunction() {
        String string = null;
        while (this.constants.contains(string = "SF" + this.skolemFunctionIndexical++) || this.functions.contains(string) || this.predicates.contains(string)) {
        }
        this.addFunction(string);
        this.notifyFOLDomainListeners(new FOLDomainSkolemFunctionAddedEvent(this, string));
        return string;
    }

    public void addPredicate(String string) {
        this.predicates.add(string);
    }

    public String addAnswerLiteral() {
        String string = null;
        while (this.constants.contains(string = "Answer" + this.answerLiteralIndexical++) || this.functions.contains(string) || this.predicates.contains(string)) {
        }
        this.addPredicate(string);
        this.notifyFOLDomainListeners(new FOLDomainAnswerLiteralAddedEvent(this, string));
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFOLDomainListener(FOLDomainListener fOLDomainListener) {
        List<FOLDomainListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(fOLDomainListener)) {
                this.listeners.add(fOLDomainListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFOLDomainListener(FOLDomainListener fOLDomainListener) {
        List<FOLDomainListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(fOLDomainListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFOLDomainListeners(FOLDomainEvent fOLDomainEvent) {
        List<FOLDomainListener> list = this.listeners;
        synchronized (list) {
            for (FOLDomainListener fOLDomainListener : this.listeners) {
                fOLDomainEvent.notifyListener(fOLDomainListener);
            }
        }
    }
}

