/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.StandardizeApartIndexical;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.FOLNode;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;

class StandardizeQuantiferVariables
implements FOLVisitor {
    private StandardizeApartIndexical quantifiedIndexical = new StandardizeApartIndexical(){
        private int index = 0;

        @Override
        public String getPrefix() {
            return "q";
        }

        @Override
        public int getNextIndex() {
            return this.index++;
        }
    };
    private SubstVisitor substVisitor = null;

    public StandardizeQuantiferVariables(SubstVisitor substVisitor) {
        this.substVisitor = substVisitor;
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object object) {
        return predicate;
    }

    @Override
    public Object visitTermEquality(TermEquality termEquality, Object object) {
        return termEquality;
    }

    @Override
    public Object visitVariable(Variable variable, Object object) {
        return variable;
    }

    @Override
    public Object visitConstant(Constant constant, Object object) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object object) {
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence notSentence, Object object) {
        return new NotSentence((Sentence)notSentence.getNegated().accept(this, object));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
        return new ConnectedSentence(connectedSentence.getConnector(), (Sentence)connectedSentence.getFirst().accept(this, object), (Sentence)connectedSentence.getSecond().accept(this, object));
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
        FOLNode fOLNode2;
        Set set = (Set)object;
        LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (FOLNode fOLNode2 : quantifiedSentence.getVariables()) {
            if (set.contains(fOLNode2)) {
                Variable variable = new Variable(this.quantifiedIndexical.getPrefix() + this.quantifiedIndexical.getNextIndex());
                linkedHashMap.put((Variable)fOLNode2, variable);
                arrayList.add(variable);
                continue;
            }
            arrayList.add((Variable)fOLNode2);
        }
        Sentence sentence = this.substVisitor.subst(linkedHashMap, quantifiedSentence.getQuantified());
        set.addAll(arrayList);
        fOLNode2 = (Sentence)sentence.accept(this, object);
        return new QuantifiedSentence(quantifiedSentence.getQuantifier(), arrayList, (Sentence)fOLNode2);
    }
}

