/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.common;

import aima.logic.common.Lexer;
import aima.logic.common.ParseTreeNode;
import aima.logic.common.Token;

public abstract class Parser {
    protected Lexer lexer;
    protected Token[] lookAheadBuffer;
    protected int lookAhead = 3;

    protected void fillLookAheadBuffer() {
        for (int i = 0; i < this.lookAhead; ++i) {
            this.lookAheadBuffer[i] = this.lexer.nextToken();
        }
    }

    protected Token lookAhead(int n) {
        return this.lookAheadBuffer[n - 1];
    }

    protected void consume() {
        this.loadNextTokenFromInput();
    }

    protected void loadNextTokenFromInput() {
        boolean bl = false;
        for (int i = 0; i < this.lookAhead - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfInput(this.lookAheadBuffer[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            try {
                this.lookAheadBuffer[this.lookAhead - 1] = this.lexer.nextToken();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean isEndOfInput(Token token) {
        return token.getType() == 9999;
    }

    protected void match(String string) {
        if (!this.lookAhead(1).getText().equals(string)) {
            throw new RuntimeException("Syntax error detected at match. Expected " + string + " but got " + this.lookAhead(1).getText());
        }
        this.consume();
    }

    public abstract ParseTreeNode parse(String var1);
}

