/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.util.Matrix;
import java.util.List;

public class Vector
extends Matrix {
    public Vector(int n) {
        super(n, 1);
    }

    public Vector(List<Double> list) {
        super(list.size(), 1);
        for (int i = 0; i < list.size(); ++i) {
            this.setValue(i, list.get(i));
        }
    }

    public double getValue(int n) {
        return super.get(n, 0);
    }

    public void setValue(int n, double d) {
        super.set(n, 0, d);
    }

    public Vector copyVector() {
        Vector vector = new Vector(this.getRowDimension());
        for (int i = 0; i < this.getRowDimension(); ++i) {
            vector.setValue(i, this.getValue(i));
        }
        return vector;
    }

    public int size() {
        return this.getRowDimension();
    }

    public Vector minus(Vector vector) {
        Vector vector2 = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            vector2.setValue(i, this.getValue(i) - vector.getValue(i));
        }
        return vector2;
    }

    public Vector plus(Vector vector) {
        Vector vector2 = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            vector2.setValue(i, this.getValue(i) + vector.getValue(i));
        }
        return vector2;
    }

    public int indexHavingMaxValue() {
        if (this.size() <= 0) {
            throw new RuntimeException("can't perform this op on empty vector");
        }
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getValue(i) > this.getValue(n))) continue;
            n = i;
        }
        return n;
    }
}

