/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.neural.ActivationFunction;
import aima.learning.neural.Vector;
import aima.util.Matrix;
import aima.util.Util;

public class Layer {
    private final Matrix weightMatrix;
    Vector biasVector;
    Vector lastBiasUpdateVector;
    private final ActivationFunction activationFunction;
    private Vector lastActivationValues;
    private Vector lastInducedField;
    private Matrix lastWeightUpdateMatrix;
    private Matrix penultimateWeightUpdateMatrix;
    private Vector penultimateBiasUpdateVector;
    private Vector lastInput;

    public Layer(Matrix matrix, Vector vector, ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        this.weightMatrix = matrix;
        this.lastWeightUpdateMatrix = new Matrix(matrix.getRowDimension(), matrix.getColumnDimension());
        this.penultimateWeightUpdateMatrix = new Matrix(matrix.getRowDimension(), matrix.getColumnDimension());
        this.biasVector = vector;
        this.lastBiasUpdateVector = new Vector(vector.getRowDimension());
        this.penultimateBiasUpdateVector = new Vector(vector.getRowDimension());
    }

    public Layer(int n, int n2, double d, double d2, ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        this.weightMatrix = new Matrix(n, n2);
        this.lastWeightUpdateMatrix = new Matrix(this.weightMatrix.getRowDimension(), this.weightMatrix.getColumnDimension());
        this.penultimateWeightUpdateMatrix = new Matrix(this.weightMatrix.getRowDimension(), this.weightMatrix.getColumnDimension());
        this.biasVector = new Vector(n);
        this.lastBiasUpdateVector = new Vector(this.biasVector.getRowDimension());
        this.penultimateBiasUpdateVector = new Vector(this.biasVector.getRowDimension());
        Layer.initializeMatrix(this.weightMatrix, d, d2);
        Layer.initializeVector(this.biasVector, d, d2);
    }

    public Vector feedForward(Vector vector) {
        this.lastInput = vector;
        Matrix matrix = this.weightMatrix.times(vector).plus(this.biasVector);
        Vector vector2 = new Vector(this.numberOfNeurons());
        for (int i = 0; i < this.numberOfNeurons(); ++i) {
            vector2.setValue(i, matrix.get(i, 0));
        }
        this.lastInducedField = vector2.copyVector();
        Vector vector3 = new Vector(this.numberOfNeurons());
        for (int i = 0; i < this.numberOfNeurons(); ++i) {
            vector3.setValue(i, this.activationFunction.activation(vector2.getValue(i)));
        }
        this.lastActivationValues = vector3.copyVector();
        return vector3;
    }

    public Matrix getWeightMatrix() {
        return this.weightMatrix;
    }

    public Vector getBiasVector() {
        return this.biasVector;
    }

    public int numberOfNeurons() {
        return this.weightMatrix.getRowDimension();
    }

    public int numberOfInputs() {
        return this.weightMatrix.getColumnDimension();
    }

    public Vector getLastActivationValues() {
        return this.lastActivationValues;
    }

    public Vector getLastInducedField() {
        return this.lastInducedField;
    }

    private static void initializeMatrix(Matrix matrix, double d, double d2) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                double d3 = Util.generateRandomDoubleBetween(d, d2);
                matrix.set(i, j, d3);
            }
        }
    }

    private static void initializeVector(Vector vector, double d, double d2) {
        for (int i = 0; i < vector.size(); ++i) {
            double d3 = Util.generateRandomDoubleBetween(d, d2);
            vector.setValue(i, d3);
        }
    }

    public Matrix getLastWeightUpdateMatrix() {
        return this.lastWeightUpdateMatrix;
    }

    public void setLastWeightUpdateMatrix(Matrix matrix) {
        this.lastWeightUpdateMatrix = matrix;
    }

    public Matrix getPenultimateWeightUpdateMatrix() {
        return this.penultimateWeightUpdateMatrix;
    }

    public void setPenultimateWeightUpdateMatrix(Matrix matrix) {
        this.penultimateWeightUpdateMatrix = matrix;
    }

    public Vector getLastBiasUpdateVector() {
        return this.lastBiasUpdateVector;
    }

    public void setLastBiasUpdateVector(Vector vector) {
        this.lastBiasUpdateVector = vector;
    }

    public Vector getPenultimateBiasUpdateVector() {
        return this.penultimateBiasUpdateVector;
    }

    public void setPenultimateBiasUpdateVector(Vector vector) {
        this.penultimateBiasUpdateVector = vector;
    }

    public void updateWeights() {
        this.weightMatrix.plusEquals(this.lastWeightUpdateMatrix);
    }

    public void updateBiases() {
        Matrix matrix = this.biasVector.plusEquals(this.lastBiasUpdateVector);
        Vector vector = new Vector(matrix.getRowDimension());
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            vector.setValue(i, matrix.get(i, 0));
        }
        this.biasVector = vector;
    }

    public Vector getLastInputValues() {
        return this.lastInput;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public void acceptNewWeightUpdate(Matrix matrix) {
        this.setPenultimateWeightUpdateMatrix(this.getLastWeightUpdateMatrix());
        this.setLastWeightUpdateMatrix(matrix);
    }

    public void acceptNewBiasUpdate(Vector vector) {
        this.setPenultimateBiasUpdateVector(this.getLastBiasUpdateVector());
        this.setLastBiasUpdateVector(vector);
    }

    public Vector errorVectorFrom(Vector vector) {
        return vector.minus(this.getLastActivationValues());
    }
}

