/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.learning.inductive.ConstantDecisonTree;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.MajorityLearner;
import aima.util.Util;
import java.util.Iterator;
import java.util.List;

public class DecisionTreeLearner
implements Learner {
    private DecisionTree tree;
    private String defaultValue;

    public DecisionTreeLearner() {
        this.defaultValue = "Unable To Classify";
    }

    public DecisionTreeLearner(DecisionTree decisionTree, String string) {
        this.tree = decisionTree;
        this.defaultValue = string;
    }

    @Override
    public void train(DataSet dataSet) {
        List<String> list = dataSet.getNonTargetAttributes();
        this.tree = this.decisionTreeLearning(dataSet, list, new ConstantDecisonTree(this.defaultValue));
    }

    @Override
    public String predict(Example example) {
        return (String)this.tree.predict(example);
    }

    @Override
    public int[] test(DataSet dataSet) {
        int[] nArray = new int[]{0, 0};
        for (Example example : dataSet.examples) {
            if (example.targetValue().equals(this.tree.predict(example))) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    private DecisionTree decisionTreeLearning(DataSet dataSet, List<String> list, ConstantDecisonTree constantDecisonTree) {
        if (dataSet.size() == 0) {
            return constantDecisonTree;
        }
        if (this.allExamplesHaveSameClassification(dataSet)) {
            return new ConstantDecisonTree(dataSet.getExample(0).targetValue());
        }
        if (list.size() == 0) {
            return this.majorityValue(dataSet);
        }
        String string = this.chooseAttribute(dataSet, list);
        DecisionTree decisionTree = new DecisionTree(string);
        ConstantDecisonTree constantDecisonTree2 = this.majorityValue(dataSet);
        List<String> list2 = dataSet.getPossibleAttributeValues(string);
        for (String string2 : list2) {
            DataSet dataSet2 = dataSet.matchingDataSet(string, string2);
            List<String> list3 = Util.removeFrom(list, string);
            DecisionTree decisionTree2 = this.decisionTreeLearning(dataSet2, list3, constantDecisonTree2);
            decisionTree.addNode(string2, decisionTree2);
        }
        return decisionTree;
    }

    private ConstantDecisonTree majorityValue(DataSet dataSet) {
        MajorityLearner majorityLearner = new MajorityLearner();
        majorityLearner.train(dataSet);
        return new ConstantDecisonTree(majorityLearner.predict(dataSet.getExample(0)));
    }

    private String chooseAttribute(DataSet dataSet, List<String> list) {
        double d = 0.0;
        String string = list.get(0);
        for (String string2 : list) {
            double d2 = dataSet.calculateGainFor(string2);
            if (!(d2 > d)) continue;
            d = d2;
            string = string2;
        }
        return string;
    }

    private boolean allExamplesHaveSameClassification(DataSet dataSet) {
        String string = dataSet.getExample(0).targetValue();
        Iterator<Example> iterator = dataSet.iterator();
        while (iterator.hasNext()) {
            Example example = iterator.next();
            if (example.targetValue().equals(string)) continue;
            return false;
        }
        return true;
    }

    public DecisionTree getDecisionTree() {
        return this.tree;
    }
}

