/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.learning.knowledge.CurrentBestLearning;
import aima.learning.knowledge.FOLDataSetDomain;
import aima.learning.knowledge.FOLExample;
import aima.learning.knowledge.Hypothesis;
import aima.logic.fol.inference.FOLOTTERLikeTheoremProver;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.kb.FOLKnowledgeBase;
import java.util.ArrayList;

public class CurrentBestLearner
implements Learner {
    private String trueGoalValue = null;
    private FOLDataSetDomain folDSDomain = null;
    private FOLKnowledgeBase kb = null;
    private Hypothesis currentBestHypothesis = null;

    public CurrentBestLearner(String string) {
        this.trueGoalValue = string;
    }

    @Override
    public void train(DataSet dataSet) {
        this.folDSDomain = new FOLDataSetDomain(dataSet.specification, this.trueGoalValue);
        ArrayList<FOLExample> arrayList = new ArrayList<FOLExample>();
        int n = 1;
        for (Example example : dataSet.examples) {
            arrayList.add(new FOLExample(this.folDSDomain, example, n));
            ++n;
        }
        this.kb = new FOLKnowledgeBase(this.folDSDomain, new FOLOTTERLikeTheoremProver(1000L, false));
        CurrentBestLearning currentBestLearning = new CurrentBestLearning(this.folDSDomain, this.kb);
        this.currentBestHypothesis = currentBestLearning.currentBestLearning(arrayList);
    }

    @Override
    public String predict(Example example) {
        String string = "~" + example.targetValue();
        if (null != this.currentBestHypothesis) {
            FOLExample fOLExample = new FOLExample(this.folDSDomain, example, 0);
            this.kb.clear();
            this.kb.tell(fOLExample.getDescription());
            this.kb.tell(this.currentBestHypothesis.getHypothesis());
            InferenceResult inferenceResult = this.kb.ask(fOLExample.getClassification());
            if (inferenceResult.isTrue()) {
                if (this.trueGoalValue.equals(example.targetValue())) {
                    string = example.targetValue();
                }
            } else if ((inferenceResult.isPossiblyFalse() || inferenceResult.isUnknownDueToTimeout()) && !this.trueGoalValue.equals(example.targetValue())) {
                string = example.targetValue();
            }
        }
        return string;
    }

    @Override
    public int[] test(DataSet dataSet) {
        int[] nArray = new int[]{0, 0};
        for (Example example : dataSet.examples) {
            if (example.targetValue().equals(this.predict(example))) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }
}

