/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.demos;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.framework.Learner;
import aima.learning.inductive.DLTestFactory;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.AdaBoostLearner;
import aima.learning.learners.DecisionListLearner;
import aima.learning.learners.DecisionTreeLearner;
import aima.learning.learners.StumpLearner;
import aima.learning.neural.BackPropLearning;
import aima.learning.neural.FeedForwardNeuralNetwork;
import aima.learning.neural.IrisDataSetNumerizer;
import aima.learning.neural.IrisNNDataSet;
import aima.learning.neural.NNConfig;
import aima.learning.neural.Perceptron;
import aima.util.Util;
import java.util.ArrayList;
import java.util.List;

public class LearningDemo {
    public static void main(String[] stringArray) {
        LearningDemo.decisionTreeDemo();
        LearningDemo.decisionListDemo();
        LearningDemo.ensembleLearningDemo();
        LearningDemo.perceptronDemo();
        LearningDemo.backPropogationDemo();
    }

    private static void decisionTreeDemo() {
        System.out.println(Util.ntimes("*", 100));
        System.out.println("\nDecisionTree Demo - Inducing a DecisionList from the Restaurant DataSet\n ");
        System.out.println(Util.ntimes("*", 100));
        try {
            DataSet dataSet = DataSetFactory.getRestaurantDataSet();
            DecisionTreeLearner decisionTreeLearner = new DecisionTreeLearner();
            decisionTreeLearner.train(dataSet);
            System.out.println("The Induced Decision Tree is ");
            System.out.println(decisionTreeLearner.getDecisionTree());
            int[] nArray = decisionTreeLearner.test(dataSet);
            System.out.println("\nThis Decision Tree classifies the data set with " + nArray[0] + " successes" + " and " + nArray[1] + " failures");
            System.out.println("\n");
        }
        catch (Exception exception) {
            System.out.println("Decision Tree Demo Failed  ");
            exception.printStackTrace();
        }
    }

    private static void decisionListDemo() {
        try {
            System.out.println(Util.ntimes("*", 100));
            System.out.println("DecisionList Demo - Inducing a DecisionList from the Restaurant DataSet\n ");
            System.out.println(Util.ntimes("*", 100));
            DataSet dataSet = DataSetFactory.getRestaurantDataSet();
            DecisionListLearner decisionListLearner = new DecisionListLearner("Yes", "No", new DLTestFactory());
            decisionListLearner.train(dataSet);
            System.out.println("The Induced DecisionList is");
            System.out.println(decisionListLearner.getDecisionList());
            int[] nArray = decisionListLearner.test(dataSet);
            System.out.println("\nThis Decision List classifies the data set with " + nArray[0] + " successes" + " and " + nArray[1] + " failures");
            System.out.println("\n");
        }
        catch (Exception exception) {
            System.out.println("Decision ListDemo Failed");
        }
    }

    private static void ensembleLearningDemo() {
        System.out.println(Util.ntimes("*", 100));
        System.out.println("\n Ensemble Decision Demo - Weak Learners co operating to give Superior decisions ");
        System.out.println(Util.ntimes("*", 100));
        try {
            DataSet dataSet = DataSetFactory.getRestaurantDataSet();
            List<DecisionTree> list = DecisionTree.getStumpsFor(dataSet, "Yes", "No");
            ArrayList<Learner> arrayList = new ArrayList<Learner>();
            System.out.println("\nStump Learners vote to decide in this algorithm");
            Object adaBoostLearner = list.iterator();
            while (adaBoostLearner.hasNext()) {
                DecisionTree object2;
                DecisionTree decisionTree = object2 = adaBoostLearner.next();
                StumpLearner stumpLearner = new StumpLearner(decisionTree, "No");
                arrayList.add(stumpLearner);
            }
            adaBoostLearner = new AdaBoostLearner(arrayList, dataSet);
            ((AdaBoostLearner)adaBoostLearner).train(dataSet);
            int[] nArray = ((AdaBoostLearner)adaBoostLearner).test(dataSet);
            System.out.println("\nThis Ensemble Learner  classifies the data set with " + nArray[0] + " successes" + " and " + nArray[1] + " failures");
            System.out.println("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void perceptronDemo() {
        try {
            System.out.println(Util.ntimes("*", 100));
            System.out.println("\n Perceptron Demo - Running Perceptron on Iris data Set with 10 epochs of learning ");
            System.out.println(Util.ntimes("*", 100));
            DataSet dataSet = DataSetFactory.getIrisDataSet();
            IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
            IrisNNDataSet irisNNDataSet = new IrisNNDataSet();
            irisNNDataSet.createExamplesFromDataSet(dataSet, irisDataSetNumerizer);
            Perceptron perceptron = new Perceptron(3, 4);
            perceptron.trainOn(irisNNDataSet, 10);
            irisNNDataSet.refreshDataset();
            int[] nArray = perceptron.testOnDataSet(irisNNDataSet);
            System.out.println(nArray[0] + " right, " + nArray[1] + " wrong");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void backPropogationDemo() {
        try {
            System.out.println(Util.ntimes("*", 100));
            System.out.println("\n BackpropagationDemo  - Running BackProp on Iris data Set with 10 epochs of learning ");
            System.out.println(Util.ntimes("*", 100));
            DataSet dataSet = DataSetFactory.getIrisDataSet();
            IrisDataSetNumerizer irisDataSetNumerizer = new IrisDataSetNumerizer();
            IrisNNDataSet irisNNDataSet = new IrisNNDataSet();
            irisNNDataSet.createExamplesFromDataSet(dataSet, irisDataSetNumerizer);
            NNConfig nNConfig = new NNConfig();
            nNConfig.setConfig("number_of_inputs", 4);
            nNConfig.setConfig("number_of_outputs", 3);
            nNConfig.setConfig("number_of_hidden_neurons", 6);
            nNConfig.setConfig("lower_limit_weights", -2.0);
            nNConfig.setConfig("upper_limit_weights", 2.0);
            FeedForwardNeuralNetwork feedForwardNeuralNetwork = new FeedForwardNeuralNetwork(nNConfig);
            feedForwardNeuralNetwork.setTrainingScheme(new BackPropLearning(0.1, 0.9));
            feedForwardNeuralNetwork.trainOn(irisNNDataSet, 10);
            irisNNDataSet.refreshDataset();
            int[] nArray = feedForwardNeuralNetwork.testOnDataSet(irisNNDataSet);
            System.out.println(nArray[0] + " right, " + nArray[1] + " wrong");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

