/*
 * Decompiled with CFR 0.152.
 */
package aima.basic;

import aima.basic.Agent;
import aima.basic.Environment;
import aima.basic.EnvironmentObject;
import aima.basic.ObjectWithDynamicAttributes;
import aima.basic.Percept;
import aima.basic.Wall;
import aima.basic.XYLocation;
import aima.util.Calculator;
import java.util.ArrayList;
import java.util.List;

public class XYEnvironment
extends Environment {
    public static String LOCATION = "location";
    int width;
    int height;
    XYLocation defaultLocation;

    public XYEnvironment() {
    }

    public XYEnvironment(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.defaultLocation = new XYLocation(1, 1);
    }

    public void addObject(EnvironmentObject environmentObject, XYLocation xYLocation) {
        super.addObject(environmentObject, LOCATION, xYLocation);
    }

    public void addAgent(Agent agent, XYLocation xYLocation) {
        super.addAgent(agent, LOCATION, xYLocation);
    }

    public void moveObjectToAbsoluteLocation(Agent agent, XYLocation xYLocation) {
        agent.setAttribute(LOCATION, xYLocation);
    }

    public void moveObject(Agent agent, String string) {
        XYLocation xYLocation = (XYLocation)agent.getAttribute(LOCATION);
        XYLocation xYLocation2 = xYLocation.locationAt(string);
        if (!this.isBlocked(xYLocation2)) {
            this.moveObjectToAbsoluteLocation(agent, xYLocation2);
        }
    }

    public ArrayList<ObjectWithDynamicAttributes> getObjectsAt(XYLocation xYLocation) {
        ArrayList<ObjectWithDynamicAttributes> arrayList = new ArrayList<ObjectWithDynamicAttributes>();
        List<ObjectWithDynamicAttributes> list = this.getAllObjects();
        for (ObjectWithDynamicAttributes objectWithDynamicAttributes : list) {
            XYLocation xYLocation2 = (XYLocation)objectWithDynamicAttributes.getAttribute(LOCATION);
            if (!xYLocation2.equals(xYLocation)) continue;
            arrayList.add(objectWithDynamicAttributes);
        }
        return arrayList;
    }

    public ArrayList getObjectsNear(Agent agent, int n) {
        ArrayList<ObjectWithDynamicAttributes> arrayList = new ArrayList<ObjectWithDynamicAttributes>();
        XYLocation xYLocation = (XYLocation)agent.getAttribute(LOCATION);
        List<ObjectWithDynamicAttributes> list = this.getAllObjects();
        for (ObjectWithDynamicAttributes objectWithDynamicAttributes : list) {
            XYLocation xYLocation2;
            if (objectWithDynamicAttributes.equals(agent) || !this.withinRadius(n, xYLocation, xYLocation2 = (XYLocation)objectWithDynamicAttributes.getAttribute(LOCATION))) continue;
            arrayList.add(objectWithDynamicAttributes);
        }
        return arrayList;
    }

    private boolean withinRadius(int n, XYLocation xYLocation, XYLocation xYLocation2) {
        int n2;
        int n3 = Calculator.calculateSquareOfDistanceBetweenLocations(xYLocation, xYLocation2);
        boolean bl = n3 <= (n2 = n * n);
        return bl;
    }

    @Override
    public void executeAction(Agent agent, String string) {
    }

    @Override
    public Percept getPerceptSeenBy(Agent agent) {
        return new Percept();
    }

    public boolean isBlocked(XYLocation xYLocation) {
        boolean bl = false;
        ArrayList<ObjectWithDynamicAttributes> arrayList = this.getObjectsAt(xYLocation);
        for (ObjectWithDynamicAttributes objectWithDynamicAttributes : arrayList) {
            if (!(objectWithDynamicAttributes instanceof Wall)) continue;
            bl = true;
        }
        return bl;
    }

    public void makePerimeter() {
        XYLocation xYLocation;
        XYLocation xYLocation2;
        int n;
        for (n = 0; n < this.width; ++n) {
            xYLocation2 = new XYLocation(n, 0);
            xYLocation = new XYLocation(n, this.height - 1);
            this.addObject(new Wall(), xYLocation2);
            this.addObject(new Wall(), xYLocation);
        }
        for (n = 0; n < this.height; ++n) {
            xYLocation2 = new XYLocation(0, n);
            xYLocation = new XYLocation(this.width - 1, n);
            this.addObject(new Wall(), xYLocation2);
            this.addObject(new Wall(), xYLocation);
        }
    }
}

