interface Personaggio {
	public String getForza();
}

interface Umano extends Personaggio {
	public void combatti();
}

interface Mostro extends Personaggio {
	public void azzanna();
}

class Vampiro implements Mostro {
	private int forza;
	
	Vampiro() {
		this.forza=15;
	}
	
	public void azzanna() {
		this.forza-=2;
	}
	
	public String getForza() {
		return "Forza rimanente del Vampiro: "+ this.forza;
	}
	
}

class Eroe implements Umano {
	private int forza;
	
	Eroe() {
		this.forza=10;
	}
	
	public void combatti() {
		this.forza-=3;
	}
	
	public String getForza() {
		return "Forza rimanente dell'Eroe: "+ this.forza;
	}
	
}

class Licantropo implements Umano, Mostro {
	private boolean isUomo;
	protected int forzaUmano;
	protected int forzaMostro;
	
	Licantropo(boolean luna) {
		this.isUomo=!luna;
		this.forzaMostro=0;
		this.forzaUmano=0;
		if(this.isUomo)
			this.forzaUmano=10;
		else
			this.forzaMostro=15;
	}
	
	public void combatti() {
		this.forzaUmano-=3;
	}
	
	public void azzanna() {
		this.forzaMostro-=2;
	}
	
	public String getForza() {
		return "Forza rimanente del Licantropo, Umano: "+ this.forzaUmano+" - Lupo: "+this.forzaMostro;
	}
	
}

public class Es2 {

	public static void main(String[] args) {
		Eroe e = new Eroe();
		Licantropo l = new Licantropo(true);
		Vampiro v = new Vampiro();
		for (int i =0; i<3;i++)
			e.combatti();
		v.azzanna();
		l.azzanna();
		l.azzanna();
		System.out.println(v.getForza());
		System.out.println(l.getForza());
		System.out.println(e.getForza());
	}

}
