#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "element.h"
#include "tree.h"

/* funzione che crea un albero di interi */
tree create_tree(tree t) {
  element el;
	int c;
	if (t != NULL) {
        free_tree(t);
		t = emptytree();
	}

	do {
		el = getElement();
		t = ord_ins(el, t);
		printf("Vuoi continuare? [1/0] ");
		scanf("%d", &c);
	} while (c != 0);

    return t;
}

int main() {
    element temp;
	tree t = emptytree();
    int dim;
    int cmd = 0;

    while (true) {
        printf("-----------------------\n");
        printf("Inserire\n");
        printf("1 per generare l'albero\n");
        printf("2 per la stampa di tipo preord\n");
        printf("3 per la stampa di tipo postord\n");
        printf("4 per la stampa di tipo inord\n");
        printf("5 per cercare un elemento con ricerca semplice\n");
        printf("6 per calcolare l'altezza dell'albero\n");
        printf("7 per calcolare la somma degli elementi dell'albero\n");
        printf("8 per calcolare il numero di nodi\n");
        printf("9 per calcolare il bilanciamento di nodi\n");
        printf("0 per uscire\n");
        printf("Scegli un'ozpione: ");
        scanf("%d", &cmd);

        switch (cmd) {
            case 1:
                t = create_tree(t);
                break;
            case 2:
                printf("Stampa preorder dell'albero:\n");
                preorder(t);
                printf("\n");
                break;
            case 3:
                printf("Stampa postorder dell'albero:\n");
                postorder(t);
                printf("\n");
                break;
            case 4:
                printf("Stampa inorder dell'albero:\n");
                inorder(t);
                printf("\n");
                break;
            case 5:
                printf("Ricerca standard dell'elemento...\n");
                temp = getElement();
                if (member(temp, t)) {
                    printf("Elemento trovato\n");
                    break;
                }
                printf("Elemento non trovato\n");
                break;
            case 6:
                printf("L'altezza dell'albero e': %d\n", height(t));
                break;
            case 7:
                printf("La somma degli elementi dell'albero e': ");
				        printElement(sum(t));
				        printf("\n");
                break;
            case 8:
                printf("Il numero di nodi dell'albero e': %d\n", nnodes(t));
                break;
            case 9:
                printf("Il bilanciamento della radice e': %d\n", balance(t));
                break;
            case 0:
                printf("Uscita\n");
                exit(0);
        }
    }

    printf("Fine.\n");
	
	return 0;
}
