#include <stdlib.h>
#include "tree.h"

/* test di albero vuoto */
boolean empty(tree t) {
    return (t == NULL);
}

/* inizializza un albero vuoto */
tree emptytree(void) {
    return NULL;
}

/* costruisce un albero che ha nella
radice e; per sottoalberi sinistro e
destro l ed r rispettivamente */
tree cons_tree(element e, tree l, tree r) {
    tree t;
    t = (NODO *) malloc(sizeof (NODO));
    t-> value = e;
    t-> left = l;
    t-> right = r;
    return (t);
}

/* restituisce la radice dell'albero t */
element root(tree t) {
    if (empty(t)) 
        abort();
    else 
        return (t->value);
}

/* restituisce il sottoalbero sinistro */
tree left(tree t) {
    if (empty(t)) 
        return (NULL);
    else 
        return (t->left);
}

/* restituisce il sottoalbero destro */
tree right(tree t) {
    if (empty(t)) 
        return (NULL);
    else 
        return (t->right);
}

tree ord_ins(element e, tree t) {
    if (empty(t))
        return (cons_tree(e, emptytree(), emptytree()));
    else {
		if (isLess(e, root(t)) || isEqual(e, root(t)))
			t->left = ord_ins(e, left(t));
		else
			t->right = ord_ins(e, right(t));

		return t;
    }
}


/* stampa preorder*/
void preorder(tree t) {
    if (!empty(t)) {
		printElement(root(t));
		preorder(left(t));
		preorder(right(t));
    }
}

/* stampa post order*/
void postorder(tree t) {
    if (!empty(t)) {
        postorder(left(t));
		postorder(right(t));
		printElement(root(t));
    }
}

/* stampa in ordine*/
void inorder(tree t) {
    if (!empty(t)) {
        inorder(left(t));
		printElement(root(t));
		inorder(right(t));
    }
}

/* ricerca di un elemento */
boolean member(element e, tree t) {
    if (empty(t)) return false;
    else if (isEqual(e, root(t))) return true;

    else return ( member(e, left(t)) || member(e, right(t)));
    }

/* somma del contenuto dei nodi */
element sum(tree t) {
	element ris;
    if (empty(t)) return 0;

    else {
		ris = sumElement(sum(left(t)), sum(right(t)));
		return sumElement(t->value, ris);
	}
}

/* conteggio dei nodi */
int nnodes(tree t) {
    if (empty(t)) 
        return 0;
    else 
        return 1 + nnodes(left(t)) + nnodes(right(t));
}


int mymax(int a, int b) {
    if (a >= b) 
        return a; 
    return b; 
}

int height_aux(tree t) {
    if (empty(t)) 
        return 0;
    else 
        return 1 + mymax(height_aux(left(t)), height_aux(right(t)));
}

/* altezza dell'albero */
int height(tree t) {
    if (empty(t)) 
        return 0;
    else 
        return mymax(height_aux(left(t)), height_aux(right(t)));
}


/* bilanciamento dell'albero */
int balance(tree t) {
    if (empty(t)) 
        return 0;
    else 
        return (height(right(t)) - height(left(t)));
}

void free_tree(tree t) {
    if (t != NULL) {
        free_tree(left(t));
        free_tree(right(t));
        free(t);
    }
}
