#ifndef TREE_H
#define TREE_H
#include<stdio.h>

#include"element.h"

typedef struct nodo {
	element value;
	struct nodo *left, *right;
} NODO;

typedef NODO *tree;

/*PRIMITIVE*/
boolean empty(tree);
tree emptytree(void);
element root(tree);
tree left(tree);
tree right(tree);
tree cons_tree(element,tree ,tree);

/*DERIVATE*/
tree ord_ins(element, tree);
void preorder(tree);
void inorder(tree);
void postorder(tree);
boolean member(element, tree);
int nnodes(tree);
element sum(tree);

int height(tree t);
int height_aux(tree t);

int balance (tree t);

// Funzione non richiesta, libera la memoria allocata per l'albero
void free_tree(tree t);

#endif
