#include "liste.h"

list cons(int n, list l) {
    list aux = NULL;

    aux = (list)malloc(sizeof(listNode));
    aux->value = n;
    aux->next = l;
    return aux;
}

list consTail(int n, list l) {
    if(l == NULL) {
        return cons(n,l);
    }
    else {
        list t = NULL;
        t = l;
		while(!(t->next == NULL)) { 
            // finche' non e' finita la lista
            t = t->next;
        }
        t->next = cons(n,NULL); // inserisco n alla fine della lista
        return l;
    }
}



/*
 * La direttiva #ifndef permette di selezionare, prima della compilazione, quali parti di codice compilare
 * Il programma finale avrà solo una delle due parti sottostanti
 */
#ifndef RECURSIVE

void showlist(list l) {
    while(!(l == NULL)) {
		printf("%d ", l->value);
        l = l->next;
    }
    printf("\n");
}

int sumlist(list l) {
	int sum = 0;

	if(l == NULL) {
		return 0;
    }

	while(!(l == NULL)) { 
        //finché non è finita la lista
		sum += l->value;
        l = l->next;
    }

	return sum;
}

// La funzione restituisce solamente trovato o non trovato.
// Per restituire l'indice, basta aggiungere una variabile di
// tipo intero i, inizializzata a 0, da incrementare ad ogni 
// iterazione
boolean member(int n, list l) {

    while(!(l == NULL)) {
        if(n == l->value){
            return TRUE;
        }
        l = l->next;
    }

    return FALSE;
}

int length(list l) {
    int count = 0;
    while(!(l == NULL)) {
        count++;
        l = l->next;
    }

    return count;
}

list sublist(int k, list l) {
	int i = 0;
	if(l == NULL) {
		return NULL;
    }

	while(k > 1 && l != NULL) {
		l = l->next;
		k--;
	}

	return l;
}

#endif

#ifdef RECURSIVE

int sumlist(list l) {
	if(l == NULL) {
		return 0;
    }
	else {
		return (l->value + sumlist(l->next));
    }
}

// Come sopra, questa funzione member restituisce solo trovato
// o non trovato. Per restiuire anche la posizione, bisogna
// aggiungere un terzo argomento che rappresenta l'indice al 
// quale siamo arrivati
boolean member(int n, list l) {

    if(l == NULL) {
        return FALSE;
    }
    else {
        if(n == l->value) {
            return TRUE;
        }
        else {
            return member(n, l->next);
        }
    }
}

int length(list l) {

    if(l == NULL) {
        return 0;
    }
    else{
        return 1 + length(l->next);
    }
}

void showlist(list l) {

    if(!(l == NULL)) {
        printf("%d ", l->value);
        showlist(l->next);
    }
    else {
        printf("\n");
    }
}

list sublist(int k, list l) {
	if(l == NULL) {
		return NULL;
    }

	if(k == 1) {
		return l;
    }
	else {
		return sublist(k-1, l->next);
    }
}

#endif
