#include "funzioni.h"

/* Stampa a video dell'intera rubrica */
void stampa(rubrica R, int n) {
	int i = 0;
	printf("\nCOGNOME:\tNOME:\t\tTELEFONO:\n");
	while (i<n) {
		printf("%s\t\t%s\t\t%s\n",R[i].cognome,R[i].nome,R[i].tel);
		i++;
	}
}


/* Inserimento di un nuovo elemento nella rubrica */
int inserimento_ord(rubrica R, int n) {
	//ESERCIZIO 2
	elemento e1;
	if (n<DIM) {
		printf("\nInserire cognome: ");
		scanf("%s" ,e1.cognome);
		printf("\nInserire nome: ");
		scanf("%s" ,e1.nome);
		if(individua_binaria(R,n, e1)==-1){
			R[n]=e1;
			printf("\nInserire numero di telefono: ");
			scanf("%s" ,R[n].tel);
			n++;
			qsort(R,n,sizeof(elemento),compare);
		}
		else 
		 printf("Individuo gia' presente in rubrica, impossibile aggiungere\n");
	}
	//fine ESERCIZIO 2
	/*
	ESERCIZIO 1
	if (n<DIM) {
		printf("\nInserire cognome: ");
		scanf("%s" ,R[n].cognome);
		printf("\nInserire nome: ");
		scanf("%s" ,R[n].nome);
		printf("\nInserire numero di telefono: ");
		scanf("%s" ,R[n].tel);
		n++;
		
		qsort(R,n,sizeof(elemento),compare);
	}*/
	else {
		printf("Rubrica piena\n");
	}
	return n;
}


int compare(const void *e1, const void *e2) {
	int cmp;
	elemento v1,v2;

	v1 = *(elemento*) e1;
	v2 = *(elemento*) e2;
	// Con strcmp si esegue un confronto case SENSITIVE (A < a, Z<a)
	if((cmp= strcmp(v1.cognome,v2.cognome)) != 0 )
		return cmp;
	else
		return strcmp(v1.nome,v2.nome);
}

void ricerca(rubrica R, int n, char surname[], char name[]){
	elemento el;
	strcpy(el.cognome, surname);
	strcpy(el.nome, name);
	int indice = individua_binaria (R, n, el);
	if(indice >=0)
		printf("%s", R[indice].tel);
	else 
		printf("Il nome digitato non e' presente in rubrica\n");
}

int individua_binaria (rubrica R, int n, elemento el){
	int indice = -1, trovato = 0;
	int min = 0;
	int max = n-1;
	int med = (min+max)/2;
	while((min<=max) && trovato==0){
		if(compare(&el, &R[med])==0){
			indice = med;
			trovato = 1;
		}
		else if (compare(&el, &R[med])<0){
			max = med-1;
		}
		else{
			min = med+1;
		}			
		med = (min+max)/2;
	}
	return indice;	
}