#include "funzioni.h"

void azzera() {
	FILE* fb;
	fb = fopen("rubrica.dat", "wb");
	if(fb == NULL) {
		exit(-1);
	}
	fclose(fb);
}


/* Stampa a video dell'intera rubrica */
void stampa() {
	FILE* fb;
	elemento el;

	fb = fopen("rubrica.dat", "rb");
	if(fb == NULL) {
		exit(-1);
	}

	printf("\nCOGNOME:\tNOME:\t\tTELEFONO:\n");
	while (fread(&el, sizeof(elemento), 1, fb)) {		
		printf("%s\t\t%s\t\t%s\n", el.cognome, el.nome, el.tel);
	}

	fclose(fb);
}


/* Inserimento di un nuovo elemento nella rubrica */
void inserimento_ord() {
	FILE* fb;
	elemento el;
	elemento elRead;
	elemento trovato;
	long pos;
	long nToShift;
	long endFile;
	int found = 0;
	int i;

	fb = fopen("rubrica.dat", "r+b");
	if (fb == NULL)	{
		printf("Errore apertura file\n");
		exit(-1);
	}

	printf("\nInserire cognome: ");
	scanf("%s", el.cognome);
	printf("\nInserire nome: ");
	scanf("%s", el.nome);
	trovato = ricerca_binaria(el);
	if(strcmp(trovato.cognome, "") == 0) {
		printf("\nInserisci tel: ");
		scanf("%s", el.tel);

		while ((found == 0) && (fread(&elRead, sizeof(elemento), 1, fb) > 0)) {
		//ricerca della posizione di inserimento
			if (compare(el, elRead) < 0) {
				found = 1;
			}
		}
		
		if (ftell(fb) == 0) {
			pos = 0;
		}
		else {
			pos = ftell(fb) - sizeof(elemento);
		}

		fseek(fb, 0, SEEK_END);
		endFile = ftell(fb);
		if(found==0){
			pos = endFile;
		}
		nToShift = (endFile - pos) / (long)sizeof(elemento); // calcolo del numero di elementi da spostare
		// spostamento "a destra"
		for (i = 0; i <= nToShift; i++) {
			fseek(fb, endFile - (i + 1) * (long)sizeof(elemento), SEEK_SET);
			fread(&elRead, sizeof(elemento), 1, fb);
			fseek(fb, endFile - i * sizeof(elemento), SEEK_SET);
			fwrite(&elRead, sizeof(elemento), 1, fb);
		}
		fseek(fb, pos, SEEK_SET);
		fwrite(&el, sizeof(elemento), 1, fb);
	}
	else {
		printf("Impossibile inserire, elemento gia' presente\n");
	}
	
	fclose(fb);
}


int compare(elemento e1, elemento e2) {
	int cmp;
	// Con strcmp si esegue un confronto case SENSITIVE (A < a, Z<a)
	if((cmp= strcmp(e1.cognome,e2.cognome)) != 0 )
		return cmp;
	else
		return strcmp(e1.nome,e2.nome);
}

void ricerca() {
	elemento e;
	elemento trovato;

	printf("\nInserire cognome: ");
	scanf("%s", e.cognome);
	printf("\nInserire nome: ");
	scanf("%s", e.nome);

	trovato = ricerca_binaria(e);
	
	if(strcmp(trovato.cognome, "")==0){
		printf("elemento non trovato\n");
	}
	else {
		printf("%s\t\t%s\t\t%s\n", trovato.cognome, trovato.nome, trovato.tel);
	}
}

/* Questa funzione effettua la ricerca binaria direttamente su file
*/
elemento ricerca_binaria(elemento el) {
	FILE* f;
	elemento elRead;
	long lSize, medium, init = 0;
	f = fopen("rubrica.dat", "rb");
	if (f == NULL) {
		printf("Errore apertura file\n");
		exit(-1);
	}
	fseek(f, 0, SEEK_END); // POSIZIONAMENTO A FINE FILE
	lSize = ftell(f) / sizeof(elemento); // NUM. BLOCCHI NEL FILE
	while ((init < lSize)) {
		medium = (init + lSize) / 2;
		fseek(f, medium * sizeof(elemento), SEEK_SET); //SEEK_SET inizio file
		if (fread(&elRead, sizeof(elemento), 1, f) > 0) {
			if (!compare(el, elRead)) {
				fclose(f);
				return elRead;
			}
			else {
				if (compare(el, elRead) > 0) {
					init = medium + 1;
				}
				else {
					lSize = medium;
				} 
			}
		}
	}

	fclose(f);
	strcpy(elRead.cognome, "");
	
	return elRead;
}