import java.io.*;

interface Comparabile {
    public boolean maggioreDi(Object x);
}

class Bambino implements Comparabile {
    private int eta;
    private String nome;

    public Bambino (int n, String nome) {
        this.eta = n;
        this.nome = nome;
    }

    public boolean maggioreDi(Object x) {
        Bambino altro = (Bambino)x;
        if (eta>altro.eta) return true;
        else return false;
    }

    public String toString() {
        return(nome  + " " + eta + "\n");
    }
}

public class Prova {
    public static void main(String[] args) {
        BufferedReader bin = null;
        Bambino[] bambini;
        bambini = new Bambino[2];

        try {
            bin = new BufferedReader(new FileReader("input.txt"));

            String line;
            int i = 0;
            while ((line = bin.readLine()) != null) {
                String[] parts = line.split(" ");
                bambini[i] = new Bambino(Integer.parseInt(parts[1]), parts[0]);
                i++;
            }
     
            System.out.println("Il bambino maggiore:\n");
            if (bambini[0].maggioreDi(bambini[1])) 
                System.out.println(bambini[0]);
            else System.out.println(bambini[1]);

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                bin.close();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}
