import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Exercise1 {

    public static void main(String[] args) {

              
        
        /*
         * Come suggerito nelle slide a questo punto abbiamo due possibilità per 
         * procedere:
         *      1) Leggere, usando il metodo read() (o read(byte[]), 4 byte, resitituiti dalla 
         *         funzione come interi, e convertire i 4 byte nel reale valore
         *         intero contenuto nel file
         *           -> problemi: devo implementare un metodo per la conversione
         *                        poichè Java non mette a disposizione metodi
         *                        di per eseguirlo.
         *      2) Usare il metodo readInt() che legge dallo stream un intero,
         *         quindi 4 byte dallo stream
         *           -> problemi: devo gestire una eccezione ulteriore, visto 
         *                        che il metodo solleva una EOFException quando
         *                        raggiunge la fine del file.
         * 
         * 
         * Di seguito verranno mostrate entrambe le implementazioni. L'esercizio
         * era pensato per esercitarsi sulle eccezioni quindi la seconda 
         * soluzione in questo caso sarebbe da preferire alla prima. L'esercizio
         * viene comunque considerato corretto in entrambi i casi.
         */
        
        /*
         * PRIMO METODO
         */
        
        FileInputStream in1 = null;
        DataOutputStream out1 = null;
        
        try {
            // Uso FileInputStream
            in1 = new FileInputStream("IN.DAT");
            out1 = new DataOutputStream(new FileOutputStream("OUT_1.DAT"));

            // La funzione read() restituisce -1 se è alla fine del file,
            // un intero tra 0 e 255 altrimenti.
            /*
             * Volendo utilizzare la funzione read() dovrei leggere il 
             * primo byte, se > -1 continuo a leggere i successivi
             * 
             * int bytes[] = new int[4];
             * while ((bytes[0] = in.read()) > -1) {
             *      for (int i = 1; i < 4; i++)
             *          bytes[i] = in.read();
             *      
             *      ....
             * 
             * In realtà mi conviene sfruttare la funzione read(byte[]) 
             * in modo da leggere direttamente tutti 4 i byte
             * 
             */
             
            byte bytes[] = new byte[4];

            
            while ((in1.read(bytes)) == 4) {
                /* Ora dobbiamo convertire.
                 * 
                 * A questo punto per fare la conversione bisogna sapere 
                 * come vengono salvate le informazioni in memoria e le modalità
                 * di conversione tra binari e interi.
                 * 
                 * Se avessimo a che fare solo con numeri positivi potremmo usare
                 * la seguente riga per convertire
                 * 
                 * int value = (bytes[0]*8) + (bytes[1]*4) + (bytes[2]*2) + (bytes[3]);
                 * 
                 * La stessa non funziona in caso di numeri negativi poichè il 
                 * segno negativo viene descritto in complemento a 2, in pratica,
                 * senza entrare nel dettaglio, se 5 in binario su 16 bit (2 byte)
                 * è descritto da 0000 0000 0000 0101
                 * allora -5 sarà 1111 1111 1111 1011
                 * (procedimento: inverto 1 con 0 e viceverse e alla fine sommo 1)
                 * 
                 * quindi 1 sarà  0000 0000 0000 0001
                 * e -1 risulterà 1111 1111 1111 1111
                 * 
                 * a questo punto prendendo byte per byte avrò -1 -1
                 * 
                 * 1111 1111 1111 1111
                 * [  -1   ] [  -1   ]
                 * 
                 * quindi facendo il calcolo
                 * value= (bytes[0]*8) + (bytes[1]*4) + (bytes[2]*2) + (bytes[3])
                 * nel caso avessi -1 nel file value = (-8) + (-4) + (-2) + (-1) = -15
                 * 
                 * Il calcolo corretto deve sfruttare il masking (coprire i bit inutili),
                 * e lo shifting per spostarli nella posizione corretta.
                 * Il calcolo corretto è mostrato di seguito.
                 * 
                 * NB ancora nei vostri corsi argomenti simili non sono stati 
                 *    trattati nel dettaglio, verranno visti in esami a scelta 
                 *    futuri quindi non vi verrà mai richiesto in sede di esame
                 *    calcoli simili. L'esercizio infatti, come già detto sopra
                 *    era pensato per sfruttare il secondo metodo che viene 
                 *    presentato più avanti. Questo vi è stato messo solo per 
                 *    soddisfare eventuali curiosità.
                 */
                int value = ((bytes[0] & 0xff) << 24 ) + ((bytes[1] & 0xff) << 16 ) + ((bytes[2] & 0xff) << 8 ) + ((bytes[3] & 0xff) );
                
                if (value > 5 || value < -5) {
                    // Risolvo all'interno l'eccezione lanciata nel caso di numero
                    // fuori intervallo. Abbiamo scelto di usare la NumberFormatException
                    // ma poteva essere sfruttata anche la più generale Exception 
                    // throw new Exception("Number " + number + " out of range!");
                    try {
                        throw new NumberFormatException("Number " + value + " out of range!");
                    } catch (NumberFormatException ex) {
                        System.out.println(ex.getMessage());
                    }
                } else {
                    out1.writeInt(value);
                }
            }

        } catch (IOException e) {
            System.err.println(e);
        } finally {
            try {
                if (in1 != null) {
                    in1.close();
                }
                if (out1 != null) {
                    out1.close();
                }
            } catch (IOException ex) {
                System.err.println(ex);
            }
        }
        
        
        /*
         * SECONDO METODO
         * Per risolvere l'esercizio usando questo metodo avete già tutti gli 
         * strumenti, la difficoltà sta nel capire come sfruttarli nel modo 
         * migliore.
         * 
         * In questo caso useremo DataInputStream e DataOutputStream. Il secondo
         * è lo stesso usato nella prima versione. Il secondo mette a disposizione
         * il metodo readInt() che, dalle API (andatele a vedere, durante l'esame
         * potrebbero servirvi), legge dallo stream un intero resituendolo
         * (quindi esegue già le conversioni da byte a int con complemento a due).
         * Se leggendo raggiunge la fine del file solleva una
         * eccezione la EOFException, quindi lo svolgimento sarà:
         *   - leggo l'intero,
         *   - lo elaboro
         *  se trovo EOFException chiudo i due stream.
         */
        
        DataInputStream in2 = null;
        DataOutputStream out2 = null;
        
        try {
            in2 = new DataInputStream(new FileInputStream("IN.DAT"));
            out2 = new DataOutputStream(new FileOutputStream("OUT_2.DAT"));


            // Ciclo infinito, l'uscita mi sarà data dall'eccezione sollevata.
            while (true) {
                int number = in2.readInt();
                if (number > 5 || number < -5) {
                    // Risolvo all'interno l'eccezione lanciata nel caso di numero
                    // fuori intervallo. Abbiamo scelto di usare la NumberFormatException
                    // ma poteva essere sfruttata anche la più generale Exception 
                    // throw new Exception("Number " + number + " out of range!");
                    try {
                        throw new NumberFormatException("Number " + number + " out of range!");
                    } catch (NumberFormatException ex) {
                        System.out.println(ex.getMessage());
                    }
                } else {
                    out2.writeInt(number);
                }
            }

        } catch (IOException e) {
            // EOFException è una sottoclasse di IOException (lo vedete nelle API)
            // quindi, visto che abbiamo deciso che tutte queste eccezioni
            // vengono risolte chiudendo i due stream, viene gestita assieme a
            // tutte le altre possibili eccezioni (FileNotFoundException, ...).
            try {
                if (in2 != null) {
                    in2.close();
                }
                if (out2 != null) {
                    out2.close();
                }
            } catch (IOException ex) {
                System.err.println(ex);
            }

        }
    }
}

