import java.io.*;

// INTERFACCIA
interface Player{
    public boolean piuForteDi(Object x);
}

// CLASSE
class TennisPlayer implements Player {

    private String nome;
    private double matchVinti;

    public TennisPlayer(String nome, double matchVinti) {
        this.nome = nome;
        this.matchVinti = matchVinti;
    }

    public String toString() {
        return this.nome + ": " + this.matchVinti;
    }

    public boolean piuForteDi(Object x) {

        // Per pignoleria massima, dovrei controllare la fattibilità del cast:
        //      x instanceof TennisPlayer

        // CAST
        TennisPlayer Y = (TennisPlayer) x;

        // Confronto campi matchVinti
        if (this.matchVinti > Y.matchVinti) {
            return true;
        } else {
            return false;
        }
        // Può essere ridotto a:
        //      return this.matchVinti > Y.matchVinti;

    }

}


// CLASSE PRINCIPALE
public class Prova {

    public static void main(String[] args) {

        // Creazione istanze
        TennisPlayer sinner = new TennisPlayer("Jannick Sinner", 61.4);
        TennisPlayer nadal = new TennisPlayer("Rafael Nadal", 64.93);

        // Creazione file

        PrintStream ps;
        try {
            ps = new PrintStream(new File("ppjava.txt"));
            ps.println(sinner.toString());
            ps.println(nadal.toString());
            ps.println(sinner.piuForteDi(nadal));
            // Volendo, ps.close() poteva essere inserito nel blocco finally
            ps.close();
        }
        catch(IOException ex) { // Non gestisco la FileNotFoundException perchè sono io da programma a creare il file

            System.out.println("Errore di sistema: " + ex);

        }
    }

}