
abstract class Persona {
    
    public String nome;
    public String cognome;
    
    Persona(String nome, String cognome) {
        
        this.nome = nome;
        this.cognome = cognome;
        
    }
    
    public abstract boolean equals(Object x);
    
}

class Studente extends Persona {
    
    public int matricola;
    
    public Studente(String nome, String cognome, int matricola) {
        
        super(nome, cognome);
        this.matricola = matricola;
        
    }
    
    public boolean equals(Object x) {
        
        if (x == null) {
            return false;
        }
        if (this == x) {
            return true;
        }
        if (!(x instanceof Persona)) {
            return false;
        }
        if (!(x instanceof Studente)) {
            return false;
        }
        Studente other = (Studente) x;
        
        return this.nome.equals(other.nome) &&
                this.cognome.equals(other.cognome) &&
                this.matricola == other.matricola;
        
    }
}

public class Giugno122013G2 {
    
    public static void main (String [] args) {
        
        Studente mr1 = new Studente("Mario", "Rossi", 12345);
        Studente mr2 = new Studente("Mario", "Rossi", 43622);
        
        if (mr1.equals(mr2)) {
            System.out.println("UGUALI!");
        } else {
            System.out.println("DIVERSI!");
        }
        
    }
}
