#include "funzioni.h"

list cons(element e, list l) {
	list a;
	a = (list)malloc(sizeof(element));
	a->value = e;
	a->next = l;
	return a;
}

list ordins(element e, list l) {
	if (l == NULL)
		return cons(e, l);
	else {
		if (e.x < l->value.x)
			return cons(e, l);
		else if ((e.x == l->value.x) && (e.y < l->value.y))
			return cons(e, l);
		else
			return cons(l->value, ordins(e, l->next));
	}
}

list funzioneA(list l, FILE *f) {
	int x, y;
	element e;
	while (!feof(f)) {
		fscanf(f,"%d %d", &x, &y);
		if(x<y)	{
			e.x = x;
			e.y = y;
			l = ordins(e, l);
		}
	}
	rewind(f);
	return l;
}

void funzioneB(list l) {
	while (l != NULL) {
		printf("%d %d\n", l->value.x, l->value.y);
		l = l->next;
	}
}

int funzioneC(list l) {
	if (l == NULL)
		return 0;
	else
		return (1 + funzioneC(l->next));
}

int fcmp(const void*a, const void*b)	{
	element e1, e2;
	e1 = *(element*)a;
	e2 = *(element*)b;
	if (e1.x < e2.x)
		return -1;
	else if ((e1.x == e2.x) && (e1.y < e2.y))
		return -1;
	else if ((e1.x == e2.x) && (e1.y == e2.y))
		return 0;
	else
		return 1;
}

void funzioneAB(element v[], FILE *f, int *n) {
	element e;
	int dim;
	while (!feof(f)) {
		fscanf(f,"%d %d", &e.x, &e.y);
		v[*n].x = e.x;
		v[*n].y = e.y;
		(*n)++;
	}
	dim = *n;
	qsort(v, dim, sizeof(element), fcmp);
}