//Settembre 2014

#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#define N 20			//dimensione massima parola
#define DIM 5			//dimensione vettore

typedef struct{
	char parola[20];
}element;

typedef struct list_element{
	element value;
	struct list_element *next;
}ITEM;

typedef ITEM *list;

//comparator per qsort
int fcmp(const void *a,const void *b){
	return (strcmp(((element*)a)->parola,((element*)b)->parola));
}

list insord(list l,element e){
	list patt=l, pprec=NULL,paux;
	int trovato=0;
	while (patt!=NULL && !trovato){
		if (strcmp(e.parola,patt->value.parola)<=0)
			trovato=1;
		else{
			pprec=patt;
			patt=patt->next;
		}
	}
	paux=(list)malloc(sizeof(ITEM));
	paux->value=e;
	paux->next=patt;
	if (patt==l)
		return paux;
	else{
		pprec->next=paux;
		return l;
	}
}

int ifvocal(element e){
	if (e.parola[0]=='a' || e.parola[0]=='e' || e.parola[0]=='i' || e.parola[0]=='o' || e.parola[0]=='u')
		return 1;
	else
		return 0;
}

//funzioneA
list buildList(FILE *f){
	list l=NULL;
	element e;
	while (fscanf(f,"%s",e.parola)!=EOF){
		if (ifvocal(e))
			l=insord(l,e);
	}
	return l;
}

//funzione per mostrare la lista a video
void showList(list l){
	if (l!=NULL){
		printf("%s\n",l->value.parola);
		showList(l->next);
	}
}

//funzione per stampare la lista su file
void printList(list l,FILE *f){
	if (l!=NULL){
		fprintf(f,"%s\n",l->value.parola);
		printList(l->next,f);
	}
}

//funzioneC
void buildVet(element v[],FILE *f){
	int i=0;
	element e;
	while (fscanf(f,"%s",e.parola)!=EOF && i<DIM){
		if (!ifvocal(e)){
			strcpy(v[i].parola,e.parola);
			i++;
		}
	}
	printf("Mostro il vettore: \n\n");
	for (i=0;i<DIM;i++){
		printf("%s\n",v[i].parola);
	}
}

main(){
	FILE *f;
	list l=NULL;
	element v[DIM];
	int i=0;
	f=fopen("parole1.txt","rt");
	if (f==NULL){
		printf("Errore apertura file 1\n");
		exit(-1);
	}
	l=buildList(f);
	fclose(f);
	printf("Mostro la lista:\n\n");
	showList(l);
	f=fopen("uscita.txt","wt");
	if (f==NULL){
		printf("Errore apertura file 2\n");
		exit(-1);
	}
	printList(l,f);
	fclose(f);
	f=fopen("parole1.txt","rt");
	if (f==NULL){
		printf("Errore apertura file 3\n");
		exit(-1);
	}
	buildVet(v,f);
	fclose(f);
	qsort(v,DIM,sizeof(element),fcmp);
	f=fopen("outputAB.txt","wt");
	if (f==NULL){
		printf("Errore apertura file 4\n");
		exit(-1);
	}
	for (i=0;i<DIM;i++){
		fprintf(f,"%s\n",v[i].parola);
	}
	fclose(f);
}