//Modulo B - 22 Luglio 2010

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define k 20
/////////////////

typedef struct
	{
	int cod;
	char comm[k];
	int bud;
	} progetto;

typedef struct
	{
	int cod;
	char offerente[k];
	int off;
	} offerta;

typedef struct   //elemento della lista
	{
	int cod;
	char comm[k];
	char offerente[k];
	int off;
	} element;

typedef struct item
	{
	element value;
	struct item* next;
	} nodo;

typedef nodo* list;

/////////////////////////

void mostra_file(FILE* f1,FILE* f2)
	{
	progetto p;
	offerta o;

	printf("\tFILE 1\n");
	while (fread(&p,sizeof(progetto),1,f1)  >0 )
		printf("%d, %s, %d\n",p.cod,p.comm,p.bud);
	printf("\n\tFILE 2\n");
	while(fread(&o,sizeof(offerta),1,f2) >0 )
		printf("%d, %s, %d\n",o.cod,o.offerente,o.off);
	}

list cons (list l,element e)
	{
	list aux;
	aux=(list)malloc(sizeof(nodo));
	aux->value=e;
	aux->next=l;
	return aux;
	}

list insOrd(list l,element e)
	{
	if(l==NULL)
		return cons(l,e);
	else if(e.cod<l->value.cod)
		return cons (l,e);
	else return cons(insOrd(l->next,e),l->value );
	}

list crea_lista(list l,FILE *f1,FILE *f2)
	{
	progetto p;
	offerta o;
	element e;

	rewind(f1);  //la testina di lettura era posizionata alla fine dei 2 file dopo che ho letto a video il loro contenuto, perci occorre riposizionarla all'inizio dei 2 file
	

	while( fread(&p,sizeof(progetto),1,f1) >0)
		{
		rewind(f2);       //in questo momento la testina di lettura del file  posizionata alla fine, quindi occorre resettarla all'inizio
		while( fread(&o,sizeof(offerta),1,f2) >0)
			if(p.cod==o.cod && p.bud>o.off)
				{
				e.cod=p.cod;
				strcpy(e.comm,p.comm);
				strcpy(e.offerente,o.offerente);
				e.off=o.off;
				l=insOrd(l,e);
				}
		}
	return l;
	}

void stampa_lista(list l)
	{
	if(l!=NULL)
		{
		printf("%d, %s, %s, %d\n",l->value.cod,l->value.comm,l->value.offerente,l->value.off);
		stampa_lista(l->next);
		}
	}

void stampa_minore(list l)
	{
	element minore=l->value;  //considero il primo elemento quello con offerta minore, poi se ne trovo uno minore di esso lo aggiorno
	l=l->next;
	while(l!=NULL)
		{
			if(l->value.off<minore.off)
				minore=l->value;
			else l=l->next;
		}
	printf("\nIl progetto con offerta minore e':%d, %s, %s con offerta %d",minore.cod,minore.comm,minore.offerente,minore.off);
	}


int stampa_offerte_VERDI(list l,char ditta[])
	{
	if(l==NULL)
		return 0;
	else if(!strcmp(l->value.offerente,ditta) )
		return 1+stampa_offerte_VERDI(l->next,ditta);
	else return stampa_offerte_VERDI(l->next,ditta);

	}

////////////////////

main()
	{
	FILE *f1;
	FILE *f2;
	list l=NULL;
	int num_verdi;

	f1=fopen("progetti.bin","rb");
	f2=fopen("offerte.bin","rb");


	if( (f1==NULL) || (f2==NULL) ) 
		exit(0);
	
	mostra_file(f1,f2);  //OK
	l=crea_lista(l,f1,f2);
	
	printf("\n\tSTAMPO LA LISTA\n");
	stampa_lista(l);
	stampa_minore(l);
	num_verdi=stampa_offerte_VERDI(l,"VERDI");
	printf("\n\nVERDI ha fatto %d offerte\n\n",num_verdi);

	fclose(f1);
	fclose(f2);
	}

// COMMENTI: tutto ok - punti 20


