/* 22 Giugno 2010
 * Modulo B
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
	char parola[20];
	int val;
} elemento;

typedef struct nod {
	elemento el;
	struct nod* l;
	struct nod* r;
} nodo;
typedef nodo* tree;

tree insord(char parola[], tree T) {
	tree tmp;
	if (T == NULL) { /* devo creare l'albero */
		tmp = (nodo*) malloc(sizeof(nodo));
		strcpy(tmp->el.parola,parola);
		tmp->l=NULL;
		tmp->r=NULL;
		tmp->el.val = 1;
		return tmp;
	} else { /* l'albero esiste */
		if ((strcmp(T->el.parola,parola)) == 0) {  /* parole uguali: incremento */
			(T->el.val)++;
			return T;
		} else if ((strcmp(T->el.parola,parola)) > 0) { /* devo infilare a sinistra */
			T->l = insord(parola, T->l);
			return T;
		} else { /* devo infilare a destra */
			T->r = insord(parola, T->r);
			return T;
		}
	}
}

void stampalbero(tree T) {
	if (T != NULL) {
		stampalbero(T->l);
		printf("%s %d\n",T->el.parola,T->el.val);
		stampalbero(T->r);
	}
}

tree fill(FILE* fp, tree T) { /* funzione che scandisce il file e riempie l'albero */
	char parola[20];
	while (!feof(fp)) {
		fscanf(fp, "%s", parola);
		T = insord(parola, T); /* per ogni parola chiamo questa funzione */
	}

	return T;
}

void loadv_aux (tree T, elemento V[], int *done, int N) {
	if (*done < N) {
		if (T!=NULL) {
			loadv_aux (T->l, V, done, N);
			if (*done < N) {
			strcpy(V[(*done)].parola,T->el.parola);
			V[(*done)].val = T->el.val;
			(*done)++;
			}
			if (*done < N) {
			 loadv_aux (T->r, V, done, N);
			}
		} 
	} 
}

void loadvector (tree T, elemento V[], int N) {
	int i = 0;
	loadv_aux (T, V, &i, N);
	
}

int compare (elemento* e1, elemento* e2) {
	if (e1->val == e2->val) { return  0; }
	if (e1->val >  e2->val) { return -1; }
	if (e1->val <  e2->val) { return  1; }
}

void sortandprint (FILE *fp, elemento V[], int N) {
	int i;

	qsort (V, N, sizeof(elemento), compare);
	
	for (i = 0; i < N; i++) {
		fprintf(fp,"%s %d\n",V[i].parola,V[i].val);
	}

}


int main() {
	FILE *fp;
	int tmp;
	elemento V[10];
	tree T = NULL;

	fp = fopen("parole.txt", "rt");
	if (fp == NULL) { printf("Errore nell'apertura del file."); exit(-1); }
	
	T = fill(fp,T); /* punto 1: riempio l'albero con il contenuto del file. */
	fclose(fp);

	loadvector(T, V, 10); /* carico i primi 10 elementi nel vettore V */

	fp = fopen("ORDINATE.TXT", "wt");

	sortandprint (fp, V, 10); /* ordino e stampo nel file */

	fclose(fp);

	return 0;

	//PERFETTO - COMPLIMENTI!, punti 20 + 1 
}

