
#include "list.h"

list funzione_1(FILE *ft, FILE *fb)
{
	element testo, binario, aux;
	boolean trovato = false;
	int letti=1;
	list l=emptylist();

	while( fscanf(ft,"%s %d",testo.sala,&testo.interventi) !=EOF )			//lettura file di testo
	{		
		while( (letti > 0) && !trovato )
		{
			letti = fread(&binario,sizeof(element),1,fb);					//lettura file binario
			
			if( strcmp(testo.sala,binario.sala) == 0 )						//cerco una sala in comune nei due file
				trovato = true;												//se la trovo, esco dal ciclo interno
		}

		strcpy(aux.sala,testo.sala);										//creo l'elemento da inserire nella lista

		if(trovato)
			aux.interventi = testo.interventi + binario.interventi;
		else
			aux.interventi = testo.interventi;
		
	
		l=insord(aux,l);													//inserimento ordinato
		
		trovato = false;													//resetto le variabili modificate nel ciclo interno: i caratteri letti, il risultato della ricerca e riporto il file binario all'inizio
		rewind(fb);
		letti=1;
	}

	return l;
}



element funzione_2(list l)
{
	element massimo;

	massimo = root(l);														//caso di partenza: il massimo  il primo valore della lista
	l = tail(l);

	while(!empty(l))
	{
		if( (root(l).interventi)>massimo.interventi )
		{
			massimo.interventi = root(l).interventi;						//aggiorno il massimo
			strcpy( massimo.sala,root(l).sala );
		}

		l=tail(l);
	}

	return massimo;
}




main()
{
	FILE* ft;
	FILE* fb;
	list L;
	element risultato;

	if( (ft = fopen("sale.txt","rt"))==NULL )									//apertura dei file e controllo
	{
		printf("errore apertura file di testo\n");
		exit(1);
	}
	if( (fb = fopen("interventi.bin","rb"))==NULL )
	{
		printf("errore apertura file binario\n");
		exit(2);
	}

	L = funzione_1(ft, fb);
	
	fclose(ft);																	//chiusura dei file
	fclose(fb);

	printf("LISTA OTTENUTA:\n\n");												//stampa la lista finale
	showlist(L);


	risultato = funzione_2(L);

	printf("\n\n\nSALA CON PIU' INTERVENTI:\t");								//stampa risultato finale
	print_element(risultato);
}




























