package EsercizioJava;

import java.io.*;

abstract class RiferimentoBibliografico
{
	private String autore;
	private String titolo;
	private int annoPubblicazione;
	public RiferimentoBibliografico(String autore, String titolo, int annoPubblicazione)
	{
		this.autore=autore;
		this.titolo=titolo;
		this.annoPubblicazione=annoPubblicazione;
	}
	public abstract String cita();
	public String getAutore()
	{
		return autore;
	}
	public String getTitolo()
	{
		return titolo;
	}
	public int getAnnoPubblicazione()
	{
		return annoPubblicazione;
	}
}

class Libro extends RiferimentoBibliografico
{
	private String ISBN;
	public Libro(String autore, String titolo, int annoPubblicazione, String ISBN)
	{
		super(autore, titolo, annoPubblicazione);
		this.ISBN=ISBN;
	}
	public String cita()
	{
		return getAutore()+", "+getTitolo()+", "+ISBN+", "+getAnnoPubblicazione()+".";
	}
}

class Articolo extends RiferimentoBibliografico
{
	private String nomeRivista;
	private int numero;
	public Articolo(String autore, String titolo, int annoPubblicazione, String nomeRivista, int numero)
	{
		super(autore, titolo, annoPubblicazione);
		this.nomeRivista=nomeRivista;
		this.numero=numero;
	}
	public String cita()
	{
		return getAutore()+", "+getTitolo()+", "+nomeRivista+", n. "+ numero+", "+getAnnoPubblicazione()+".";
	}
}

public class Prova 
{

	public static void main(String[] args) 
	{
		RiferimentoBibliografico[] bibliografia=new RiferimentoBibliografico[2];
		
		bibliografia[0]=new Libro("R.Seacord", "Effective C", 2020, "ISBN: 9781718501041");
		bibliografia[1]=new Articolo("P.Pallino", "Come superare gli esami con poca fatica", 2017, "Rivista dello studente universitario",10);
		
		try
		{
			FileWriter fw=new FileWriter("ppjava.txt");
			PrintWriter output=new PrintWriter(fw);
			
			output.write(bibliografia[0].cita()+"\n"+bibliografia[1].cita());
			
			output.close();
		}
		catch(IOException e)
		{
			System.out.println("Errore: "+e);
		}
	}

}
