#define _CRT_SECURE_NO_WARNINGS
#define DIM 20
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

typedef enum{true, false}boolean; //tipo enumerativo per la funzione di ricerca member

typedef struct nodo {
	char parola[DIM];
	struct nodo* left;
	struct nodo* right;
}NODO;

typedef NODO* tree;

FILE* apri_file(char nomefile[DIM], char modalita[2]) //funzione per controllare il file aperto
{
	FILE* f;
	f = fopen(nomefile, modalita);
	if (f == NULL)
	{
		printf("\n\nErrore nell'apertura del file %s, si procede alla chiusura del programma...\n", nomefile);
		exit(-1);
	}
	else
		printf("\nIl file %s e' stato aperto correttaemnte...\n", nomefile);
	return f;
}

tree cons(char parola[DIM], tree l, tree r)
{
	tree T;
	T = (tree)malloc(sizeof(NODO));
	strcpy(T->parola, parola);
	T->left = l;
	T->right = r;
	return T;
}

tree ordins(char parola[DIM], tree t) {
	if (t == NULL)
		return cons(parola, NULL, NULL);
	else {
		if (strcmp(parola, t->parola) <= 0)
			t->left = ordins(parola, t->left);
		else
			t->right = ordins(parola, t->right);
		return t;
	}
}

boolean member(char parola[DIM], tree T) {
	if (T == NULL)
		return false;
	else
		if (strcmp(parola, T->parola) == 0)
			return true;
		else
			if (strcmp(parola, T->parola) < 0)
				return member(parola, T->left);
			else
				return member(parola, T->right);
}

tree funzione1(FILE* f) {
	tree T = NULL;
	char parola[DIM];
	boolean presente = false;

	while (!feof(f)) {
		fread(parola, sizeof(parola), 1, f);//legge una parola dal file binario
		//cerca la parola appena letta nell'albero se  gia presente non la inserisce, se non  presente la inserisce
		presente = member(parola, T);
		if (presente == false)
		{
			T = ordins(parola, T);
		}
	}

	return T;
}

void funzione2(tree T, FILE* f) {
	if (T != NULL) {
		funzione2(T->left, f);
		fprintf(f, "%s\n", T->parola);
		funzione2(T->right, f);
	}
}

int main() {
	FILE* input, * output;
	tree T = NULL;

	//apre il file parole1.bin in lettura binaria
	input = apri_file("parole1.bin", "rb");
	//chiama la funzione1
	T = funzione1(input);
	//chiude il file parole1.bin
	fclose(input);

	//apre il file uscita.txt in scrittura testuale
	output = apri_file("uscita.txt", "wt");
	//chiama la funzione2
	funzione2(T, output);
	//chiude il file uscita.txt
	fclose(output);
}