/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package OmniForm;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

/**
 *
 * @author Luca
 */
public class MainForm extends JFrame implements ActionListener {
    
    
    /** Il costruttore della classe. */
    public MainForm() throws Exception {
        super("Swing Test");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setJMenuBar(this.createMenuBar());
        // Layout della Frame:
        this.setLayout(new BorderLayout());
        this.getContentPane().add(this.getMainPanel(), BorderLayout.CENTER);
        
        // La centro nello schermo:
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        System.out.println(UIManager.getLookAndFeel().getName());
    }
        
    
    /** Il metodo serve per creare un TabbedPane che contenga diversi 
     *  JPanel con tutte le classi grafiche che mostriamo.
     */
    private JTabbedPane getMainPanel() {
        JTabbedPane mainpanel = new JTabbedPane();
        // Il pane dei componenti:
        mainpanel.addTab("Components", this.getComponentsPanel());
        // Il pane della TextArea:
        mainpanel.addTab("TextArea", this.getTextAreaPanel());
        // L'editor pane:
        mainpanel.addTab("EditorPane", this.getEditorPanePanel());
        // La tabella:
        mainpanel.addTab("Table", this.getTablePanel());
        // Il Desktop pane:
        mainpanel.addTab("Desktop", this.getDesktopPanel());
        return mainpanel;
    }
    
    
    
    /** Il metodo serve per mostrare il pannello con alcuni componenti della swing. */
    private JPanel getComponentsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Object[] data = new Object[] {
            "Primo elmento",
            "Secondo elemento",
            "Terzo elemento",
            "Quarto elemento",
            "Quinto elemento",
            "Sesto elemento"
        };
        // Pannello centrale:
        JPanel center = new JPanel();
        center.setBorder(new TitledBorder("Alcuni componenti Swing:"));
        center.setLayout(new GridLayout(5,1));
        // Primo pannello:
        JPanel first = new JPanel();
        first.setLayout(new FlowLayout(FlowLayout.LEFT));
        JLabel label = new JLabel("JTextField: ");
        label.setPreferredSize(new Dimension(150, 25));
        JTextField textfield = new JTextField("Si può scrivere qua");
        textfield.setPreferredSize(new Dimension(300, 25));
        first.add(label);
        first.add(textfield);
        center.add(first);
        // Secondo pannello:
        JPanel second = new JPanel();
        second.setLayout(new FlowLayout(FlowLayout.LEFT));
        JLabel lpass = new JLabel("JPasswordField: ");
        lpass.setPreferredSize(new Dimension(150, 25));
        JPasswordField password = new JPasswordField("password");
        password.setEchoChar('*');
        password.setPreferredSize(new Dimension(300, 25));
        second.add(lpass);
        second.add(password);
        center.add(second);
        // Il terzo pannello:
        JPanel third = new JPanel();
        third.setLayout(new FlowLayout(FlowLayout.LEFT));
        JLabel lcombo = new JLabel("JComboBox: ");
        lcombo.setPreferredSize(new Dimension(150, 25));
        JComboBox combo = new JComboBox(data);
        combo.setSelectedIndex(0);
        combo.setPreferredSize(new Dimension(300, 25));
        third.add(lcombo);
        third.add(combo);
        center.add(third);
        // Il quarto pannello:
        JPanel fourth = new JPanel();
        fourth.setBorder(new TitledBorder("JRadioButton: "));
        fourth.setLayout(new FlowLayout(FlowLayout.CENTER, 80, 20));
        ButtonGroup group = new ButtonGroup();
        JRadioButton radio1 = new JRadioButton("Scelta 1");
        JRadioButton radio2 = new JRadioButton("Scelta 2");
        JRadioButton radio3 = new JRadioButton("Scelta 3");
        group.add(radio1);
        group.add(radio2);
        group.add(radio3);
        fourth.add(radio1);
        fourth.add(radio2);
        fourth.add(radio3);
        center.add(fourth);
        // Il quinto pannello:
        JPanel fifth = new JPanel();
        fifth.setBorder(new TitledBorder("JCheckBox: "));
        fifth.setLayout(new FlowLayout(FlowLayout.CENTER, 80, 20));
        JCheckBox check1 = new JCheckBox("Opzione 1");
        JCheckBox check2 = new JCheckBox("Opzione 2");
        JCheckBox check3 = new JCheckBox("Opzione 3");
        fifth.add(check1);
        fifth.add(check2);
        fifth.add(check3);
        center.add(fifth);
        // Pannello sulla destra:
        JPanel right = new JPanel();
        right.setLayout(new BorderLayout());
        JList list = new JList(data);
        JScrollPane scrollpane = new JScrollPane(list);
        right.setBorder(new TitledBorder("JList:"));
        right.add(scrollpane, BorderLayout.CENTER);
        // Aggiungo i componenti al pannello:
        panel.add(center, BorderLayout.CENTER);
        panel.add(right, BorderLayout.EAST);
        return panel;
    }
    
    
    /** Il metodo serve per prelevare il pannello che contiene l'area di testo. */
    private JPanel getTextAreaPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        // Creo una text area e l'aggiungo al pannello:
        JScrollPane scrollpane = new JScrollPane();
        JTextArea area = new JTextArea();
        scrollpane.setViewportView(area);
        panel.add(scrollpane, BorderLayout.CENTER);
        // Configuro la text area:
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        return panel;
    }
    
    
    /** Il metodo serve per creare un pannello che interpreta l'Html: */
    private JPanel getEditorPanePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        // Creo l'editor pane:
        JPanel url = new JPanel();
        url.setLayout(new FlowLayout(FlowLayout.LEFT));
        JLabel label = new JLabel("URL: ");
        this.urlfield = new JTextField("http://www.unife.it");
        this.urlfield.setPreferredSize(new Dimension(300, 25));
        JButton go = new JButton("Vai alla pagina");
        go.addActionListener(this);
        url.add(label);
        url.add(urlfield);
        url.add(go);
                
        // L'editor pane deve essere globale per essere visto dagli altri metodi.
        this.editorpane = new JEditorPane();
        editorpane.setEditable(false);
        // Inserisco l'editor pane nel pannello principale.
        JScrollPane scrollpane = new JScrollPane(editorpane);
        
        // Aggiungo i componenti al pannello:
        panel.add(url, BorderLayout.NORTH);
        panel.add(scrollpane, BorderLayout.CENTER);
        return panel;
    }
    
    
    /** Il metodo serve per creare una JTable semplicissima. */
    private JPanel getTablePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        // La tabella dei dati:
        Object[][] data = new Object[][] {
            { "Donald", "Duck", 68, new Boolean(true) },
            { "Mickey", "Mouse", 74, new Boolean(false) },
            { "Jessica", "Rabbit", 30, new Boolean(false) },
            { "Robot", "Ufo", 125, new Boolean(true) },
            { "Walker", "TexasRanger", 43, new Boolean(false) },
        };
        // Headers delle colonne:
        Object[] columnNames = new Object[] {
            "Nome", "Cognome", "Età", "Vegetariano",
        };
        TableModel model = new DefaultTableModel(data, columnNames) {
            @Override
            public Class<?> getColumnClass(int columnIndex) {
//                return super.getValueAt(0, columnIndex).getClass();
                if(columnIndex == 0 || columnIndex == 1) return String.class;
                else if(columnIndex == 2) return Integer.class;
                else if(columnIndex == 3) return Boolean.class;
                else return super.getColumnClass(columnIndex);
            }
        };
        JTable table = new JTable(model);
        table.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollpane = new JScrollPane(table);
        panel.add(scrollpane, BorderLayout.CENTER);
        return panel;
    }
    
    
    /** Il metodo serve per creare un internal desktop. */
    private JPanel getDesktopPanel() {
        // Il pannello principale:
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        // Il Pannello dei comandi:
        JPanel commands = new JPanel();
        commands.setLayout(new FlowLayout(FlowLayout.LEFT));
        JButton addform = new JButton("Nuova");
        addform.addActionListener(this);
        commands.add(addform);
        
        // Il desktop:
        this.desktop = new JDesktopPane();
        this.desktop.setBorder(new EtchedBorder(EtchedBorder.RAISED));
                
        // Aggiungo i componenti al desktop:
        panel.add(commands, BorderLayout.NORTH);
        panel.add(desktop, BorderLayout.CENTER);
        return panel;
    }
        
    
    /** Il metodo serve per creare la barra dei menu. */
    private JMenuBar createMenuBar() {
        // Creo il contenitore dei menu.
        JMenuBar menubar = new JMenuBar();
        
        // Aggiungo i menu:
        JMenu FILE = new JMenu("File");
        JMenuItem open = new JMenuItem("Apri");
        open.addActionListener(this);
        JMenuItem save = new JMenuItem("Salva");
        save.addActionListener(this);
        JMenuItem saveas = new JMenuItem("Salva come...");
        saveas.addActionListener(this);
        JMenuItem close = new JMenuItem("Chiudi");
        close.addActionListener(this);
        // Aggiungo i sottomenu:
        FILE.add(open);
        FILE.add(new JSeparator());
        FILE.add(save);
        FILE.add(saveas);
        FILE.add(new JSeparator());
        FILE.add(close);
        
        // Aggiungo il menu modifica:
        JMenu EDIT = new JMenu("Modifica");
        JMenu lookandfeel = new JMenu("Look and Feel");
        ButtonGroup group = new ButtonGroup();
        JMenuItem lookjava = new JRadioButtonMenuItem("java");
        lookjava.setSelected(true);
        lookjava.addActionListener(this);
        JMenuItem looksys = new JRadioButtonMenuItem("sistema");
        looksys.addActionListener(this);
        JMenuItem customfh = new JRadioButtonMenuItem("fh");
        customfh.addActionListener(this);
        group.add(lookjava);
        group.add(looksys);
        group.add(customfh);
        lookandfeel.add(lookjava);
        lookandfeel.add(looksys);
        lookandfeel.add(new JSeparator());
        lookandfeel.add(customfh);
        EDIT.add(lookandfeel);
        
        // Restituisco il contenitore dei menu.
        menubar.add(FILE);
        menubar.add(EDIT);
        return menubar;
    }
    
    
    
    /** Il metodo serve per far partire l'applicazione. */
    public static void main(String[] args) {
        try {
            MainForm form = new MainForm();
            form.setVisible(true);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    
    /** Questo metodo serve per gestire gli eventi che vengono lanciati dalla
     *  finestra.
     * @param e
     */
    public void actionPerformed(ActionEvent ev) {
        String comando = ev.getActionCommand().toUpperCase();
        // Gestione comandi di base:
        if(comando.equals("APRI")) {
            JFileChooser chooser = new JFileChooser(new File(System.getProperty("user.dir")));
            chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            chooser.setMultiSelectionEnabled(false);
            chooser.showOpenDialog(this);
            File selected = chooser.getSelectedFile();
            if(selected == null) return;
            String infos = "Il file: " + selected.getAbsolutePath() + "\n" +
                    "ha una dimensione di " + selected.length() + " bytes\n" +
                    "ed è stato modificato l'ultima volta " + new Date(selected.lastModified());
            JOptionPane.showMessageDialog(this, infos, "INFORMAZIONE", JOptionPane.INFORMATION_MESSAGE);
        }
        else if(comando.equals("SALVA")) {
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), BufferedImage.TYPE_INT_RGB);
            File output = new File(this.getClass().getSimpleName() + ".png");
            Graphics g = image.createGraphics();
            this.paint(g);
            try { 
                ImageIO.write(image, "png", output); 
                JOptionPane.showMessageDialog(this, "Immagine della form salvata in:\n" + output.getAbsolutePath(),
                        "INFORMAZIONE", JOptionPane.WARNING_MESSAGE);
            }
            catch(Exception e) { e.printStackTrace(); }
        }
        else if(comando.equals("SALVA COME...")) {
            JFileChooser chooser = new JFileChooser(new File(System.getProperty("user.dir")));
            chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            chooser.setMultiSelectionEnabled(false);
            chooser.showSaveDialog(this);
            File selected = chooser.getSelectedFile();
            if(selected == null) return;
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), BufferedImage.TYPE_INT_RGB);
            File output = selected;
            Graphics g = image.createGraphics();
            this.paint(g);
            try { 
                ImageIO.write(image, "png", output); 
                JOptionPane.showMessageDialog(this, "Immagine della form salvata in:\n" + output.getAbsolutePath(),
                        "INFORMAZIONE", JOptionPane.WARNING_MESSAGE);
            }
            catch(Exception e) { e.printStackTrace(); }
        }
        else if(comando.equals("CHIUDI")) {
            this.dispose();
        }
        // Modifico il look and feel:
        else if(comando.equals("JAVA")) {
            try { 
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName()); 
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch(Exception e) { e.printStackTrace(); }
        }
        else if(comando.equals("SISTEMA")) {
            try { 
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()); 
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch(Exception e) { e.printStackTrace(); }
        }
        else if(comando.equals("FH")) {
            try{ 
                UIManager.setLookAndFeel("com.shfarr.ui.plaf.fh.FhLookAndFeel"); 
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Exception e) { e.printStackTrace(); }
        }
        // Gestione Editor pane:
        else if(comando.equals("VAI ALLA PAGINA")) {
            String page = this.urlfield.getText();
            try {
                if(!page.startsWith("http://")) page = "http://" + page; 
                this.editorpane.setPage(page);
            }
            catch (Exception e) {
                this.editorpane.setContentType("text/html");
                this.editorpane.setText("<html>Could not load " + page + "</html>");
            } 
        }
        // Gestione del desktop pane:
        else if(comando.equals("NUOVA")) {
            Calendar cal = Calendar.getInstance();
            Date now = cal.getTime();
            JInternalFrame iframe = new JInternalFrame(now.toString());
            iframe.setLayout(new BorderLayout());
            iframe.setClosable(true);
            iframe.setIconifiable(true);
            iframe.setMaximizable(true);
            iframe.setSize(400, 300);
            // Aggiungo una text area.
            JTextArea area = new JTextArea();
            JScrollPane scroll = new JScrollPane(area);
            iframe.getContentPane().add(scroll, BorderLayout.CENTER);            
            this.desktop.add(iframe);
            iframe.setVisible(true);
        }
    }
    
    
    ////////////////////////////////////////////////////////////////////////////
    // Variabili private della classe:
    private JEditorPane editorpane;
    private JTextField urlfield;
    
    private JDesktopPane desktop;
}
