/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package panelgraph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

/**
 *
 * @author Luca
 */
public abstract class AbstractFunction {

    /** Il costruttore della classe. */
    public AbstractFunction(double[] x, Color colore) {
        this.x = x;
        this.colore = colore;
        this.calcolaFunzione();
    }
    
    
    /** Il metodo serve per calcolare i valori della funzione. */
    protected abstract void calcolaFunzione();
    
    
    /** Il metodo pubblico serve per disegnare la funzione. */
    public void render(Graphics2D g, double minx, double maxx, double miny, double maxy, int width, int height) {
        // Preparo i due vettori:
        int[] coord_x = new int[this.x.length];
        int[] coord_y = new int[this.fx.length];
        
        // Calcolo le coordinate:
        for(int i=0; i<this.x.length; i++) {
            // Calcolo il valore sulla X: 
            double normalized_x = this.getValoreNormalizzato(this.x[i], minx, maxx);
            coord_x[i] = (int)(normalized_x * width);
            // Calcolo il valore sulla Y:
            double normalized_y = this.getValoreNormalizzato(this.fx[i], miny, maxy);
            coord_y[i] = height - (int)(normalized_y * height);
        }
        // Disegno la poliline:
        g.setColor(this.colore);
        g.drawPolyline(coord_x, coord_y, this.x.length);
    }
    
    
    /** Il metodo protetto serve per prelevare un valore normalizzato tra 0 e 1 dati i
     * parametri del valore, del minimo e del massimo.
     */
    private double getValoreNormalizzato(double value, double min, double max) {
        double nvalue = (value - min) / (max - min);
        if(nvalue < 0.0) return 0.0;
        else if(nvalue > 1.0) return 1.0;
        else return nvalue;
    }
    
    
    ////////////////////////////////////////////////////////////////////////////
    // Variabili private della classe:
    protected double[] x;
    protected double[] fx;
    
    protected Color colore;
}
